/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project.component;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.association.NodeAssocationType;
import com.atlassian.jira.association.NodeAssociationStore;
import com.atlassian.jira.bc.EntityNotFoundException;
import com.atlassian.jira.bc.project.component.ArchivedProjectComponentAnalyticEvent;
import com.atlassian.jira.bc.project.component.ComponentConverter;
import com.atlassian.jira.bc.project.component.MutableProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentComparator;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.bc.project.component.ProjectComponentStore;
import com.atlassian.jira.bc.project.component.RestoredProjectComponentAnalyticEvent;
import com.atlassian.jira.database.DbConnectionManager;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.event.bc.project.component.ProjectComponentArchivedEvent;
import com.atlassian.jira.event.bc.project.component.ProjectComponentCreatedEvent;
import com.atlassian.jira.event.bc.project.component.ProjectComponentDeletedEvent;
import com.atlassian.jira.event.bc.project.component.ProjectComponentRestoredEvent;
import com.atlassian.jira.event.bc.project.component.ProjectComponentUpdatedEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.comparator.ComponentComparator;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.model.querydsl.QComponent;
import com.atlassian.jira.model.querydsl.QNodeAssociation;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultProjectComponentManager
implements ProjectComponentManager {
    private final ProjectComponentStore store;
    private final IssueManager issueManager;
    private final NodeAssociationStore nodeAssociationStore;
    private final DbConnectionManager dbConnectionManager;
    protected static final String FIELD_PROJECT_ID = "projectId";
    protected static final String FIELD_NAME = "name";
    protected static final String FIELD_LEAD = "lead";
    protected final EventPublisher eventPublisher;
    private UserManager userManager;
    private static final Function<ProjectComponent, Long> COMPONENT_TO_ID_TRANSFORMER = input -> input.getId();

    public DefaultProjectComponentManager(ProjectComponentStore store, IssueManager issueManager, EventPublisher eventPublisher, UserManager userManager, NodeAssociationStore nodeAssociationStore, DbConnectionManager dbConnectionManager) {
        this.store = store;
        this.issueManager = issueManager;
        this.eventPublisher = eventPublisher;
        this.userManager = userManager;
        this.nodeAssociationStore = nodeAssociationStore;
        this.dbConnectionManager = dbConnectionManager;
    }

    public ProjectComponent create(String name, String description, String lead, long assigneeType, Long projectId) throws IllegalArgumentException {
        try {
            MutableProjectComponent component = new MutableProjectComponent(null, name, description, lead, assigneeType, projectId, false);
            ProjectComponent projectComponent = this.convertToProjectComponent(this.store.store(component));
            this.eventPublisher.publish((Object)new ProjectComponentCreatedEvent(projectComponent));
            return projectComponent;
        }
        catch (EntityNotFoundException e) {
            return null;
        }
    }

    public ProjectComponent find(Long id) throws EntityNotFoundException {
        return this.convertToProjectComponent(this.store.find(id));
    }

    public ProjectComponent getProjectComponent(Long projectComponentId) {
        return this.store.getProjectComponent(projectComponentId);
    }

    public Collection<ProjectComponent> findAllForProject(Long projectId) {
        return this.convertToProjectComponents(this.store.findAllForProject(projectId));
    }

    public Collection<ProjectComponent> findAllActiveForProject(Long projectId) {
        return this.store.findAllForProject(projectId).stream().filter(component -> !component.isArchived()).map(this::convertToProjectComponent).collect(Collectors.toList());
    }

    public Collection<ProjectComponent> findAllArchivedForProject(Long projectId) {
        return this.store.findAllForProject(projectId).stream().filter(ProjectComponent::isArchived).map(this::convertToProjectComponent).collect(Collectors.toList());
    }

    public Collection<String> findAllUniqueNamesForProjects(Collection<Long> projectIds) {
        TreeSet uniqueNames = Sets.newTreeSet((Comparator)ProjectComponentComparator.COMPONENT_NAME_COMPARATOR);
        for (Long projectId : projectIds) {
            Collection<MutableProjectComponent> projectComponents = this.store.findAllForProject(projectId);
            if (projectComponents == null) continue;
            for (MutableProjectComponent component : projectComponents) {
                uniqueNames.add(component.getName());
            }
        }
        return uniqueNames;
    }

    public Collection<ProjectComponent> findAll() {
        return this.convertToProjectComponents(this.store.findAll());
    }

    public int getTotalComponentCount() {
        Collection components = this.store.findAll();
        return components != null ? components.size() : 0;
    }

    public Collection<String> findAllUniqueNamesForProjectObjects(Collection<Project> projects) {
        TreeSet uniqueNames = Sets.newTreeSet((Comparator)ProjectComponentComparator.COMPONENT_NAME_COMPARATOR);
        for (Project project : projects) {
            Collection<MutableProjectComponent> projectComponents = this.store.findAllForProject(project.getId());
            if (projectComponents == null) continue;
            for (MutableProjectComponent component : projectComponents) {
                uniqueNames.add(component.getName());
            }
        }
        return uniqueNames;
    }

    public List<ProjectComponent> getComponents(List<Long> ids) throws EntityNotFoundException {
        ArrayList<ProjectComponent> components = new ArrayList<ProjectComponent>(ids.size());
        for (Long id : ids) {
            components.add(this.find(id));
        }
        return components;
    }

    public ProjectComponent update(MutableProjectComponent component) throws EntityNotFoundException {
        ProjectComponent oldProjectComponent = this.find(component.getId());
        this.store.store(component);
        ProjectComponent projectComponent = this.convertToProjectComponent(component);
        this.eventPublisher.publish((Object)new ProjectComponentUpdatedEvent(projectComponent, oldProjectComponent));
        this.publishArchivingEvents(oldProjectComponent, projectComponent);
        return projectComponent;
    }

    private void publishArchivingEvents(ProjectComponent oldComponent, ProjectComponent updatedComponent) {
        if (!oldComponent.isArchived() && updatedComponent.isArchived()) {
            this.eventPublisher.publish((Object)new ProjectComponentArchivedEvent(updatedComponent));
            this.eventPublisher.publish((Object)new ArchivedProjectComponentAnalyticEvent(updatedComponent.getId()));
        } else if (oldComponent.isArchived() && !updatedComponent.isArchived()) {
            this.eventPublisher.publish((Object)new ProjectComponentRestoredEvent(updatedComponent));
            this.eventPublisher.publish((Object)new RestoredProjectComponentAnalyticEvent(updatedComponent.getId()));
        }
    }

    public List<ChangeItemBean> updateIssueProjectComponents(Issue issue, Collection<ProjectComponent> newValue) {
        return this.updateIssueValue(issue, newValue, this.findComponentsByIssue(issue), NodeAssocationType.ISSUE_TO_COMPONENT, "Component");
    }

    private List<ChangeItemBean> updateIssueValue(Issue issue, Collection<ProjectComponent> newComponents, Collection<ProjectComponent> oldComponents, NodeAssocationType nodeAssocationType, String changeItemField) {
        if (newComponents == null) {
            return Collections.emptyList();
        }
        ArrayList changes = Lists.newArrayListWithCapacity((int)newComponents.size());
        List oldComponentIds = CollectionUtil.transform(oldComponents, COMPONENT_TO_ID_TRANSFORMER);
        List newComponentIds = CollectionUtil.transform(newComponents, COMPONENT_TO_ID_TRANSFORMER);
        for (ProjectComponent newComponent : newComponents) {
            if (oldComponentIds.contains(newComponent.getId())) continue;
            this.nodeAssociationStore.createAssociation(nodeAssocationType, issue.getId(), newComponent.getId());
            changes.add(new ChangeItemBean("jira", changeItemField, null, null, newComponent.getId().toString(), newComponent.getName()));
        }
        for (ProjectComponent oldComponent : oldComponents) {
            if (newComponentIds.contains(oldComponent.getId())) continue;
            this.nodeAssociationStore.removeAssociation(nodeAssocationType, issue.getId(), oldComponent.getId());
            changes.add(new ChangeItemBean("jira", changeItemField, oldComponent.getId().toString(), oldComponent.getName(), null, null));
        }
        return changes;
    }

    public void delete(Long componentId) throws EntityNotFoundException {
        ProjectComponent projectComponent = null;
        if (componentId != null) {
            projectComponent = this.find(componentId);
        }
        this.store.delete(componentId);
        if (componentId != null) {
            this.eventPublisher.publish((Object)new ProjectComponentDeletedEvent(projectComponent));
        }
    }

    public void deleteAllComponents(@Nonnull Long projectId) {
        this.dbConnectionManager.execute(callback -> {
            QNodeAssociation na = QNodeAssociation.NODE_ASSOCIATION;
            QComponent c = QComponent.COMPONENT;
            callback.delete((RelationalPath<?>)na).where((Predicate)na.sinkNodeEntity.eq((Object)"IssueComponent").and((Predicate)na.sinkNodeId.in((SubQueryExpression)((SQLQuery)SQLExpressions.select(c.id).from((Expression)c)).where((Predicate)c.project.eq((Object)projectId))))).execute();
        });
        this.store.deleteAllComponents(projectId);
    }

    public boolean containsName(String name, Long projectId) {
        return this.store.containsName(name, projectId);
    }

    public Long findProjectIdForComponent(Long id) throws EntityNotFoundException {
        return this.store.findProjectIdForComponent(id);
    }

    protected ProjectComponent convertToProjectComponent(MutableProjectComponent value) {
        return this.getComponentConverter().convertToProjectComponent(value);
    }

    private Collection<ProjectComponent> convertToProjectComponents(Collection<MutableProjectComponent> mutables) {
        return this.getComponentConverter().convertToProjectComponents(mutables);
    }

    public GenericValue convertToGenericValue(ProjectComponent projectComponent) {
        if (projectComponent == null) {
            return null;
        }
        return projectComponent.getGenericValue();
    }

    public Collection<GenericValue> convertToGenericValues(Collection<ProjectComponent> projectComponents) {
        ArrayList<GenericValue> projectComponentGVs = new ArrayList<GenericValue>(projectComponents.size());
        for (ProjectComponent projectComponent : projectComponents) {
            projectComponentGVs.add(projectComponent.getGenericValue());
        }
        return projectComponentGVs;
    }

    public ProjectComponent findByComponentName(Long projectId, String componentName) {
        try {
            MutableProjectComponent pc = this.store.findByComponentName(projectId, componentName);
            return pc == null ? null : this.convertToProjectComponent(pc);
        }
        catch (EntityNotFoundException e) {
            return null;
        }
    }

    public Collection<ProjectComponent> findByComponentNameCaseInSensitive(String componentName) {
        return this.convertToProjectComponents(this.store.findByComponentNameCaseInSensitive(componentName));
    }

    public Collection<ProjectComponent> findComponentsByLead(String userName) {
        ApplicationUser appUser = this.userManager.getUserByName(userName);
        if (appUser == null) {
            return Collections.emptyList();
        }
        return this.store.findComponentsBylead(appUser.getKey());
    }

    public Collection<ProjectComponent> findComponentsByIssue(Issue issue) {
        return Entity.PROJECT_COMPONENT.buildList(this.findComponentsByIssueGV(issue));
    }

    @Nonnull
    public Collection<Long> getIssueIdsWithComponent(@Nonnull ProjectComponent component) {
        return this.nodeAssociationStore.getSourceIdsFromSink(NodeAssocationType.ISSUE_TO_COMPONENT, component.getId());
    }

    public Collection<GenericValue> findComponentsByIssueGV(Issue issue) {
        GenericValue genericValue = issue.getGenericValue();
        if (genericValue != null) {
            try {
                ArrayList<GenericValue> newValue = new ArrayList<GenericValue>(this.issueManager.getEntitiesByIssue("IssueComponent", genericValue));
                newValue.sort(ComponentComparator.COMPARATOR);
                return newValue;
            }
            catch (GenericEntityException e) {
                throw new DataAccessException("Error occurred while retrieving components for issue with id " + issue.getId() + "'.", (Throwable)e);
            }
        }
        return Collections.emptyList();
    }

    protected ComponentConverter getComponentConverter() {
        return new ComponentConverter();
    }
}

