/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project.component;

import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.ApplicationUser;
import org.ofbiz.core.entity.GenericValue;

public class ProjectComponentImpl
implements ProjectComponent {
    private final Long id;
    private final String name;
    private final long assigneeType;
    private final String lead;
    private final String description;
    private final Long projectId;
    private final boolean archived;
    private final boolean deleted;
    private final GenericValue genericValue;

    public ProjectComponentImpl(Long id, String name, String description, String lead, long assigneeType, Long projectId, boolean archived, GenericValue gv) {
        this(id, name, description, lead, assigneeType, projectId, archived, false, gv);
    }

    public ProjectComponentImpl(Long id, String name, String description, String lead, long assigneeType, Long projectId, boolean archived, boolean deleted, GenericValue gv) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.lead = lead;
        this.assigneeType = assigneeType;
        this.projectId = projectId;
        this.archived = archived;
        this.deleted = deleted;
        this.genericValue = gv;
    }

    public Long getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLead() {
        return this.lead;
    }

    public ApplicationUser getComponentLead() {
        if (this.getLead() == null) {
            return null;
        }
        return ComponentAccessor.getUserManager().getUserByKey(this.getLead());
    }

    public String getName() {
        return this.name;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public long getAssigneeType() {
        return this.assigneeType;
    }

    public boolean isArchived() {
        return this.archived;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ProjectComponent)) {
            return false;
        }
        Long thatId = ((ProjectComponent)o).getId();
        return thatId != null && thatId.equals(this.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ProjectComponentImpl { name='");
        sb.append(this.name);
        sb.append("', description='");
        sb.append(this.description == null ? "" : this.description);
        sb.append("'");
        sb.append(", lead='");
        sb.append(this.lead == null ? "" : this.lead);
        sb.append("', assigneeType='");
        sb.append(this.assigneeType);
        sb.append("', projectId='");
        sb.append(this.projectId == null ? "" : this.projectId.toString());
        sb.append("', id='");
        sb.append(this.id == null ? "" : this.id.toString());
        sb.append("', archived='");
        sb.append(this.archived);
        sb.append("', deleted='");
        sb.append(this.deleted);
        sb.append("' }");
        return sb.toString();
    }

    public GenericValue getGenericValue() {
        return this.genericValue;
    }
}

