/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project.index;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.auditing.handlers.ProjectEventHandler;
import com.atlassian.jira.bc.project.index.ProjectIndexTaskContext;
import com.atlassian.jira.bc.project.index.ProjectReindexService;
import com.atlassian.jira.bc.project.index.ReIndexProjectIndexerCommand;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.ComponentReference;
import com.atlassian.jira.index.ha.IndexSnapshotOperator;
import com.atlassian.jira.index.ha.ReplicatedIndexManager;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.index.IssueBatcherFactory;
import com.atlassian.jira.issue.index.IssueIndexer;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.util.I18nHelper;
import org.apache.log4j.Logger;

public class ProjectReindexServiceImpl
implements ProjectReindexService {
    private final JiraAuthenticationContext authenticationContext;
    private final TaskManager taskManager;
    private final IssueIndexer issueIndexer;
    private final ReplicatedIndexManager replicatedIndexManager;
    private final OfBizDelegator ofBizDelegator;
    private final IssueBatcherFactory issueBatcherFactory;
    private final SearchProvider searchProvider;
    private final IssueManager issueManager;
    private final EventPublisher eventPublisher;
    private final I18nHelper.BeanFactory i18nBeanFactory;
    private final ClusterManager clusterManager;
    private final ProjectEventHandler projectEventHandler;
    @ClusterSafe(value="This reference is loaded like this to avoid cyclic dependency")
    private final ComponentReference<IndexSnapshotOperator> indexSnapshotOperatorRef = ComponentAccessor.getComponentReference(IndexSnapshotOperator.class);
    private static final Logger log = Logger.getLogger(ProjectReindexServiceImpl.class);

    public ProjectReindexServiceImpl(JiraAuthenticationContext authenticationContext, TaskManager taskManager, IssueIndexer issueIndexer, ReplicatedIndexManager replicatedIndexManager, OfBizDelegator ofBizDelegator, IssueBatcherFactory issueBatcherFactory, SearchProvider searchProvider, IssueManager issueManager, EventPublisher eventPublisher, I18nHelper.BeanFactory i18nBeanFactory, ClusterManager clusterManager, ProjectEventHandler projectEventHandler) {
        this.authenticationContext = authenticationContext;
        this.taskManager = taskManager;
        this.issueIndexer = issueIndexer;
        this.replicatedIndexManager = replicatedIndexManager;
        this.ofBizDelegator = ofBizDelegator;
        this.issueBatcherFactory = issueBatcherFactory;
        this.searchProvider = searchProvider;
        this.issueManager = issueManager;
        this.eventPublisher = eventPublisher;
        this.i18nBeanFactory = i18nBeanFactory;
        this.clusterManager = clusterManager;
        this.projectEventHandler = projectEventHandler;
    }

    @Override
    public String reindex(Project project) {
        return this.reindex(project, true);
    }

    @Override
    public String reindex(Project project, boolean shouldReplicate) {
        String taskName = this.getText("admin.indexing.project", project.getName());
        ReIndexProjectIndexerCommand indexCallable = new ReIndexProjectIndexerCommand(project, shouldReplicate, this.ofBizDelegator, this.issueIndexer, this.taskManager, this.searchProvider, this.issueManager, this.eventPublisher, this.issueBatcherFactory, log, this.authenticationContext.getI18nHelper(), this.i18nBeanFactory, this.clusterManager, this.projectEventHandler, (IndexSnapshotOperator)this.indexSnapshotOperatorRef.get());
        String progressUrl = this.taskManager.submitTask(indexCallable, taskName, new ProjectIndexTaskContext(project, this.clusterManager.getNodeId()), true).getProgressURL();
        if (shouldReplicate) {
            this.replicatedIndexManager.reindexProject(project);
        }
        return progressUrl;
    }

    @Override
    public boolean isReindexPossible(Project project) {
        return this.taskManager.getLiveTask(new ProjectIndexTaskContext(project, this.clusterManager.getNodeId())) == null;
    }

    public String getText(String key, String parameter) {
        return this.getI18nHelper().getText(key, parameter);
    }

    private I18nHelper getI18nHelper() {
        return this.authenticationContext.getI18nHelper();
    }
}

