/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.user;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.user.ApplicationUserBuilder;
import com.atlassian.jira.bc.user.ApplicationUserBuilderImpl;
import com.atlassian.jira.bc.user.CreateUserApplicationHelper;
import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.bc.user.UserValidationHelper;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.user.UserEvent;
import com.atlassian.jira.event.user.UserEventFactory;
import com.atlassian.jira.event.user.UserProfileUpdatedEvent;
import com.atlassian.jira.event.user.UserRenamedEvent;
import com.atlassian.jira.exception.AddException;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.plugin.user.PreDeleteUserErrorsManager;
import com.atlassian.jira.plugin.user.WebErrorMessage;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserDeleteVeto;
import com.atlassian.jira.user.UserDetails;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.GlobalPermissionGroupAssociationUtil;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.SimpleWarningCollection;
import com.atlassian.jira.util.WarningCollection;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUserService
implements UserService {
    protected final Logger log = LoggerFactory.getLogger(DefaultUserService.class);
    private final UserUtil userUtil;
    private final UserDeleteVeto userDeleteVeto;
    private final UserManager userManager;
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final I18nHelper.BeanFactory i18nFactory;
    private final EventPublisher eventPublisher;
    private final PreDeleteUserErrorsManager preDeleteUserErrorsManager;
    private final CreateUserApplicationHelper applicationHelper;
    private final ApplicationRoleManager applicationRoleManager;
    private final UserValidationHelper validationsHelper;
    private final GlobalPermissionGroupAssociationUtil globalPermissionGroupAssociationUtil;
    private final GlobalPermissionManager globalPermissionManager;
    private final UserEventFactory userEventFactory;
    private final GroupManager groupManager;

    public DefaultUserService(UserUtil userUtil, UserDeleteVeto userDeleteVeto, PermissionManager permissionManager, UserManager userManager, I18nHelper.BeanFactory i18nFactory, JiraAuthenticationContext jiraAuthenticationContext, EventPublisher eventPublisher, PreDeleteUserErrorsManager preDeleteUserErrorsManager, CreateUserApplicationHelper applicationHelper, ApplicationRoleManager applicationRoleManager, UserValidationHelper validationHelper, GlobalPermissionGroupAssociationUtil globalPermissionGroupAssociationUtil, GlobalPermissionManager globalPermissionManager, UserEventFactory userEventFactory, GroupManager groupManager) {
        this.userUtil = userUtil;
        this.userDeleteVeto = userDeleteVeto;
        this.permissionManager = permissionManager;
        this.userManager = userManager;
        this.i18nFactory = i18nFactory;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.eventPublisher = eventPublisher;
        this.preDeleteUserErrorsManager = preDeleteUserErrorsManager;
        this.applicationHelper = applicationHelper;
        this.applicationRoleManager = applicationRoleManager;
        this.validationsHelper = validationHelper;
        this.globalPermissionGroupAssociationUtil = globalPermissionGroupAssociationUtil;
        this.globalPermissionManager = globalPermissionManager;
        this.userEventFactory = userEventFactory;
        this.groupManager = groupManager;
    }

    @Nonnull
    public ApplicationUserBuilder newUserBuilder(@Nonnull ApplicationUser user) {
        return new ApplicationUserBuilderImpl(user);
    }

    public UserService.CreateUserValidationResult validateCreateUserForSignup(ApplicationUser loggedInUser, String username, String password, String confirmPassword, String email, String fullname) {
        UserService.CreateUserRequest createUserRequest = UserService.CreateUserRequest.withUserDetails((ApplicationUser)loggedInUser, (String)username, (String)password, (String)email, (String)fullname).confirmPassword(confirmPassword).passwordRequired().performPermissionCheck(false).sendUserSignupEvent();
        return this.validateCreateUser(createUserRequest);
    }

    public UserService.CreateUserValidationResult validateCreateUserForSetup(ApplicationUser loggedInUser, String username, String password, String confirmPassword, String email, String fullname) {
        UserService.CreateUserRequest createUserRequest = UserService.CreateUserRequest.withUserDetails((ApplicationUser)loggedInUser, (String)username, (String)password, (String)email, (String)fullname).confirmPassword(confirmPassword).passwordRequired().performPermissionCheck(false);
        return this.validateCreateUser(createUserRequest);
    }

    public UserService.CreateUserValidationResult validateCreateUserForSignupOrSetup(ApplicationUser loggedInUser, String username, String password, String confirmPassword, String email, String fullname) {
        UserService.CreateUserRequest createUserRequest = UserService.CreateUserRequest.withUserDetails((ApplicationUser)loggedInUser, (String)username, (String)password, (String)email, (String)fullname).confirmPassword(confirmPassword).passwordRequired().performPermissionCheck(false).sendUserSignupEvent();
        return this.validateCreateUser(createUserRequest);
    }

    public UserService.CreateUserValidationResult validateCreateUser(UserService.CreateUserRequest createUserRequest) {
        Set applicationKeys = createUserRequest.requireDefaultApplicationAccess() ? this.applicationRoleManager.getDefaultApplicationKeys() : createUserRequest.getApplicationKeys();
        if (createUserRequest.shouldSkipValidation()) {
            return new UserService.CreateUserValidationResult(createUserRequest, applicationKeys, (ErrorCollection)new SimpleErrorCollection(), (List)ImmutableList.of(), (WarningCollection)new SimpleWarningCollection());
        }
        UserValidationHelper.Validations validations = this.validationsHelper.validations(createUserRequest.getLoggedInUser());
        if (createUserRequest.shouldPerformPermissionCheck() && !validations.hasCreateAccess(createUserRequest.getLoggedInUser())) {
            return new UserService.CreateUserValidationResult(validations.getErrors());
        }
        if (createUserRequest.getDirectoryId() == null ? !validations.hasWritableDefaultCreateDirectory() : !validations.writableDirectory(createUserRequest.getDirectoryId())) {
            return new UserService.CreateUserValidationResult(validations.getErrors());
        }
        if (createUserRequest.requirePassword()) {
            validations.passwordRequired(createUserRequest.getPassword(), createUserRequest.shouldConfirmPassword());
        }
        Object passwordErrors = ImmutableList.of();
        if (createUserRequest.getPassword() != null) {
            passwordErrors = validations.validatePasswordPolicy(createUserRequest.getPassword(), createUserRequest.getUsername(), createUserRequest.getDisplayName(), createUserRequest.getEmailAddress());
        }
        if (createUserRequest.shouldConfirmPassword()) {
            validations.validateConfirmPassword(createUserRequest.getPassword(), createUserRequest.getConfirmPassword());
        }
        validations.validateEmailAddress(createUserRequest.getEmailAddress());
        validations.validateDisplayName(createUserRequest.getDisplayName());
        validations.hasValidUsername(createUserRequest.getUsername(), createUserRequest.getDirectoryId());
        Collection<String> appKeyWarnings = this.applicationHelper.validateApplicationKeys(Optional.ofNullable(createUserRequest.getDirectoryId()), (Set<ApplicationKey>)applicationKeys);
        if (!appKeyWarnings.isEmpty()) {
            WarningCollection warnings = validations.getWarnings();
            appKeyWarnings.stream().forEach(arg_0 -> ((WarningCollection)warnings).addWarning(arg_0));
        }
        return new UserService.CreateUserValidationResult(createUserRequest, applicationKeys, validations.getErrors(), (List)passwordErrors, validations.getWarnings());
    }

    public UserService.CreateUserValidationResult validateCreateUserForAdmin(ApplicationUser loggedInUser, String username, String password, String confirmPassword, String email, String fullname) {
        return this.validateCreateUserForAdmin(loggedInUser, username, password, confirmPassword, email, fullname, null);
    }

    public UserService.CreateUserValidationResult validateCreateUserForAdmin(ApplicationUser loggedInUser, String username, String password, String confirmPassword, String email, String fullname, @Nullable Long directoryId) {
        UserService.CreateUserRequest createUserRequest = UserService.CreateUserRequest.withUserDetails((ApplicationUser)loggedInUser, (String)username, (String)password, (String)email, (String)fullname).inDirectory(directoryId).confirmPassword(confirmPassword);
        return this.validateCreateUser(createUserRequest);
    }

    public UserService.CreateUsernameValidationResult validateCreateUsername(ApplicationUser loggedInUser, String username) {
        return this.validateCreateUsername(loggedInUser, username, null);
    }

    public UserService.CreateUsernameValidationResult validateCreateUsername(ApplicationUser loggedInUser, String username, Long directoryId) {
        UserValidationHelper.Validations validations = this.validationsHelper.validations(loggedInUser);
        validations.hasValidUsername(username, directoryId);
        return new UserService.CreateUsernameValidationResult(username, directoryId, validations.getErrors());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationUser createUser(@Nonnull UserService.CreateUserValidationResult result) throws PermissionException, CreateException {
        Assertions.notNull((String)"You can not create a user, validation result", (Object)result);
        Assertions.is((String)"Make sure to call validateCreateUser(CreateUserRequest) before calling createUser(CreateUserValidationResult).", (boolean)result.hasCreateUserRequest());
        if (!result.isValid()) {
            throw new CreateException("Validation failed, user " + result.getUsername() + " cannot be created");
        }
        UserService.CreateUserRequest createUserRequest = result.getCreateUserRequest();
        ApplicationUser user = null;
        try {
            user = this.userManager.createUser(this.toApplicationUserCreationData(result));
            Collection<String> validateApplicationKeys = this.applicationHelper.validateApplicationKeys(Optional.ofNullable(createUserRequest.getDirectoryId()), (Set<ApplicationKey>)result.getApplicationKeys());
            if (validateApplicationKeys.isEmpty()) {
                Set<Group> groupsForCreate = this.applicationHelper.getDefaultGroupsForNewUser(result.getApplicationKeys());
                this.userUtil.addUserToGroups(groupsForCreate, user);
            } else {
                this.log.warn("User with name " + user.getName() + " created, but not added to any groups.");
            }
        }
        catch (AddException ignore) {
            this.log.warn("User with name " + createUserRequest.getUsername() + " created, but not added to any groups.");
        }
        finally {
            if (user != null) {
                this.dispatchUserCreatedEvent(result.getUsername(), result.getEmail(), result.getFullname(), result.getDirectoryId(), createUserRequest.getUserEventType(), user, createUserRequest.shouldSendNotification());
            }
        }
        return user;
    }

    private UserDetails toApplicationUserCreationData(UserService.CreateUserValidationResult validationResult) {
        return new UserDetails(validationResult.getUsername(), validationResult.getFullname()).withDirectory(validationResult.getDirectoryId()).withEmail(validationResult.getEmail()).withPassword(validationResult.getPassword());
    }

    public ApplicationUser createUserNoNotification(UserService.CreateUserValidationResult result) throws PermissionException, CreateException {
        Assertions.notNull((String)"You can not create a user with a null validation result.", (Object)result);
        Assertions.stateTrue((String)"You can not create a user with an invalid validation result.", (boolean)result.isValid());
        UserService.CreateUserRequest createUserRequest = UserService.CreateUserRequest.withUserDetails(null, (String)result.getUsername(), (String)result.getPassword(), (String)result.getEmail(), (String)result.getFullname()).inDirectory(result.getDirectoryId()).sendNotification(false).withApplicationAccess(result.getApplicationKeys()).skipValidation();
        return this.createUser(this.validateCreateUser(createUserRequest));
    }

    public ApplicationUser createUserFromSignup(UserService.CreateUserValidationResult result) throws PermissionException, CreateException {
        return this.createUserWithNotification(result, 0);
    }

    public ApplicationUser createUserWithNotification(UserService.CreateUserValidationResult result) throws PermissionException, CreateException {
        return this.createUserWithNotification(result, 1);
    }

    private ApplicationUser createUserWithNotification(UserService.CreateUserValidationResult result, int eventType) throws PermissionException, CreateException {
        Assertions.notNull((String)"You can not create a user, validation result", (Object)result);
        Assertions.stateTrue((String)"You can not create a user with an invalid validation result.", (boolean)result.isValid());
        UserService.CreateUserRequest createUserRequest = UserService.CreateUserRequest.withUserDetails(null, (String)result.getUsername(), (String)result.getPassword(), (String)result.getEmail(), (String)result.getFullname()).inDirectory(result.getDirectoryId()).sendNotification(true).withApplicationAccess(result.getApplicationKeys()).withEventUserEvent(eventType).skipValidation();
        return this.createUser(this.validateCreateUser(createUserRequest));
    }

    public UserService.UpdateUserValidationResult validateUpdateUser(ApplicationUser user) {
        ApplicationUser loggedInUser = this.jiraAuthenticationContext.getUser();
        I18nHelper i18nBean = this.getI18nBean(loggedInUser);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        UserValidationHelper.Validations validations = this.validationsHelper.validations(loggedInUser);
        if (!this.isAdministrator(loggedInUser)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.users.update.no.permission"));
            return new UserService.UpdateUserValidationResult((ErrorCollection)errors);
        }
        ApplicationUser userToUpdate = this.userManager.getUserByKey(user.getKey());
        if (userToUpdate == null) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.users.user.does.not.exist"));
            return new UserService.UpdateUserValidationResult((ErrorCollection)errors);
        }
        if (!this.userManager.canUpdateUser(userToUpdate)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.cannot.edit.user.directory.read.only"));
            return new UserService.UpdateUserValidationResult((ErrorCollection)errors);
        }
        if (!this.isSysAdmin(loggedInUser) && this.isSysAdmin(userToUpdate)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.must.be.sysadmin.to.edit.sysadmin"));
            return new UserService.UpdateUserValidationResult((ErrorCollection)errors);
        }
        if (!user.isActive()) {
            Collection projects;
            Collection components = this.userUtil.getComponentsUserLeads(userToUpdate);
            if (components.size() > 0) {
                String projectList = this.getDisplayableProjectList(this.getProjectsFor(components));
                errors.addError("active", i18nBean.getText("admin.errors.users.cannot.deactivate.due.to.component.lead", projectList));
            }
            if ((projects = this.userUtil.getProjectsLeadBy(userToUpdate)).size() > 0) {
                String projectList = this.getDisplayableProjectList(projects);
                errors.addError("active", i18nBean.getText("admin.errors.users.cannot.deactivate.due.to.project.lead", projectList));
            }
            if (loggedInUser.getName().equalsIgnoreCase(user.getUsername())) {
                errors.addErrorMessage(i18nBean.getText("admin.errors.users.cannot.deactivate.currently.logged.in"));
            }
        }
        if (!IdentifierUtils.equalsInLowerCase((String)userToUpdate.getUsername(), (String)user.getUsername())) {
            if (this.userManager.canRenameUser(userToUpdate)) {
                if (!validations.hasValidUsername(user.getUsername(), null)) {
                    errors.addErrors(validations.getErrors().getErrors());
                }
            } else {
                errors.addErrorMessage(i18nBean.getText("admin.errors.cannot.rename.due.to.configuration"));
            }
        }
        if (!IdentifierUtils.equalsInLowerCase((String)userToUpdate.getDisplayName(), (String)user.getDisplayName())) {
            if (this.userManager.canUpdateUser(userToUpdate)) {
                if (!validations.validateDisplayName(user.getDisplayName())) {
                    errors.addErrors(validations.getErrors().getErrors());
                }
            } else {
                errors.addErrorMessage(i18nBean.getText("admin.errors.cannot.rename.due.to.configuration"));
            }
        }
        if (!userToUpdate.getEmailAddress().equals(user.getEmailAddress())) {
            if (this.userManager.canUpdateUser(userToUpdate)) {
                if (!validations.validateEmailAddress(user.getEmailAddress())) {
                    errors.addErrors(validations.getErrors().getErrors());
                }
            } else {
                errors.addErrorMessage(i18nBean.getText("admin.errors.cannot.rename.due.to.configuration"));
            }
        }
        if (errors.hasAnyErrors()) {
            return new UserService.UpdateUserValidationResult((ErrorCollection)errors);
        }
        return new UserService.UpdateUserValidationResult(user);
    }

    private Collection<Project> getProjectsFor(Collection<ProjectComponent> components) {
        ProjectManager projectManager = ComponentAccessor.getProjectManager();
        HashSet<Project> projects = new HashSet<Project>(components.size());
        for (ProjectComponent component : components) {
            projects.add(projectManager.getProjectObj(component.getProjectId()));
        }
        return projects;
    }

    private String getDisplayableProjectList(Collection<Project> projects) {
        Iterable projectKeys = Iterables.transform(projects, Project::getKey);
        return StringUtils.join((Iterable)projectKeys, (String)", ");
    }

    public void updateUser(UserService.UpdateUserValidationResult updateUserValidationResult) {
        if (updateUserValidationResult.isValid()) {
            ApplicationUser oldUser = this.userManager.getUserByKey(updateUserValidationResult.getApplicationUser().getKey());
            this.userManager.updateUser(updateUserValidationResult.getApplicationUser());
            if (IdentifierUtils.equalsInLowerCase((String)oldUser.getUsername(), (String)updateUserValidationResult.getApplicationUser().getUsername())) {
                this.eventPublisher.publish((Object)new UserProfileUpdatedEvent(updateUserValidationResult.getApplicationUser(), this.jiraAuthenticationContext.getUser()));
            } else {
                this.eventPublisher.publish((Object)new UserRenamedEvent(updateUserValidationResult.getApplicationUser(), this.jiraAuthenticationContext.getUser(), oldUser.getUsername()));
            }
        } else {
            throw new IllegalStateException("Invalid UpdateUserValidationResult");
        }
    }

    public UserService.DeleteUserValidationResult validateDeleteUser(ApplicationUser loggedInUser, String username) {
        I18nHelper i18nBean = this.getI18nBean(loggedInUser);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (username == null || username.length() == 0) {
            errors.addError("username", i18nBean.getText("admin.errors.users.cannot.delete.due.to.invalid.username"));
            return new UserService.DeleteUserValidationResult((ErrorCollection)errors);
        }
        return this.validateDeleteUser(loggedInUser, this.userManager.getUserByName(username));
    }

    public UserService.DeleteUserValidationResult validateDeleteUser(ApplicationUser loggedInUser, ApplicationUser userForDelete) {
        I18nHelper i18nBean = this.getI18nBean(loggedInUser);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (!this.permissionManager.hasPermission(0, loggedInUser)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.users.delete.no.permission"));
            return new UserService.DeleteUserValidationResult((ErrorCollection)errors);
        }
        if (!this.userManager.isUserExisting(userForDelete)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.users.user.does.not.exist"));
            return new UserService.DeleteUserValidationResult((ErrorCollection)errors);
        }
        if (userForDelete.equals((Object)loggedInUser)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.users.cannot.delete.currently.logged.in"));
            return new UserService.DeleteUserValidationResult((ErrorCollection)errors);
        }
        if (!this.userManager.canUpdateUser(userForDelete)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.users.cannot.delete.user.read.only"));
            return new UserService.DeleteUserValidationResult((ErrorCollection)errors);
        }
        if (!this.isSysAdmin(loggedInUser) && this.isSysAdmin(userForDelete)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.users.cannot.delete.due.to.sysadmin"));
            return new UserService.DeleteUserValidationResult((ErrorCollection)errors);
        }
        try {
            if (!this.userManager.getUserState(userForDelete).isInMultipleDirectories()) {
                this.validateDeleteUserReferences(loggedInUser, userForDelete, i18nBean, (ErrorCollection)errors);
            }
        }
        catch (Exception e) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.exception.occured.validating") + " " + e);
        }
        if (errors.hasAnyErrors()) {
            return new UserService.DeleteUserValidationResult((ErrorCollection)errors);
        }
        return new UserService.DeleteUserValidationResult(userForDelete);
    }

    private void validateDeleteUserReferences(ApplicationUser loggedInUser, ApplicationUser userForDelete, I18nHelper i18nBean, ErrorCollection errors) throws SearchException {
        long numberOfProjectsUserLeads;
        long numberOfComments;
        long numberOfAssignedIssues;
        String username = userForDelete.getUsername();
        long numberOfReportedIssues = this.userUtil.getNumberOfReportedIssuesIgnoreSecurity(loggedInUser, userForDelete);
        if (numberOfReportedIssues > 0L) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.users.cannot.delete.due.to.reported.issues", "'" + username + "'", "" + numberOfReportedIssues));
        }
        if ((numberOfAssignedIssues = this.userUtil.getNumberOfAssignedIssuesIgnoreSecurity(loggedInUser, userForDelete)) > 0L) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.users.cannot.delete.due.to.assigned.issues", "'" + username + "'", "" + numberOfAssignedIssues));
        }
        if ((numberOfComments = this.userDeleteVeto.getCommentCountByAuthor(userForDelete)) > 0L) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.users.cannot.delete.due.to.commented.issues", "'" + username + "'", "" + numberOfComments));
        }
        if ((numberOfProjectsUserLeads = (long)this.userUtil.getProjectsLeadBy(userForDelete).size()) > 0L) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.users.cannot.delete.due.to.project.lead", "'" + username + "'", "" + numberOfProjectsUserLeads));
        }
        ImmutableList<WebErrorMessage> lst = this.preDeleteUserErrorsManager.getWarnings(userForDelete);
        for (WebErrorMessage errorMessage : lst) {
            errors.addErrorMessage(errorMessage.getDescription());
        }
    }

    private boolean isAdministrator(@Nullable ApplicationUser user) {
        return this.permissionManager.hasPermission(0, user);
    }

    private boolean isSysAdmin(@Nullable ApplicationUser user) {
        return this.permissionManager.hasPermission(44, user);
    }

    public void removeUser(ApplicationUser loggedInUser, UserService.DeleteUserValidationResult result) {
        Assertions.notNull((String)"You can not remove a user with a null validation result.", (Object)result);
        Assertions.stateTrue((String)"You can not remove a user with an invalid validation result.", (boolean)result.isValid());
        ApplicationUser userForDelete = result.getApplicationUser();
        this.userUtil.removeUser(loggedInUser, userForDelete);
    }

    I18nHelper getI18nBean(ApplicationUser user) {
        return this.i18nFactory.getInstance(user);
    }

    public UserService.AddUserToApplicationValidationResult validateAddUserToApplication(ApplicationUser user, ApplicationKey applicationKey) {
        ApplicationUser loggedInUser = null;
        if (this.jiraAuthenticationContext != null) {
            loggedInUser = this.jiraAuthenticationContext.getLoggedInUser();
        }
        return this.validateAddUserToApplication(loggedInUser, user, applicationKey);
    }

    public UserService.AddUserToApplicationValidationResult validateAddUserToApplication(ApplicationUser loggedInUser, ApplicationUser user, ApplicationKey applicationKey) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (loggedInUser == null || !this.isAdministrator(loggedInUser)) {
            errors.addErrorMessage(this.getI18nBean(loggedInUser).getText("admin.errors.users.add.user.to.application.no.permission"));
            return new UserService.AddUserToApplicationValidationResult((ErrorCollection)errors);
        }
        Collection<String> applicationKeyErrors = this.applicationHelper.validateApplicationKeys(user, (Set<ApplicationKey>)ImmutableSet.of((Object)applicationKey));
        errors.addErrorMessages(applicationKeyErrors);
        if (errors.hasAnyErrors()) {
            return new UserService.AddUserToApplicationValidationResult((ErrorCollection)errors);
        }
        return new UserService.AddUserToApplicationValidationResult(user, this.applicationRoleManager.getDefaultGroups(applicationKey));
    }

    public void addUserToApplication(UserService.AddUserToApplicationValidationResult result) throws AddException, PermissionException {
        Assertions.notNull((String)"You can not add a user to an application with a null validation result.", (Object)result);
        Assertions.is((String)"You can not add a user to an application with an invalid validation result.", (boolean)result.isValid());
        this.userUtil.addUserToGroups((Collection)result.getApplicationDefaultGroups(), result.getUserToAdd());
    }

    public UserService.RemoveUserFromApplicationValidationResult validateRemoveUserFromApplication(ApplicationUser user, ApplicationKey applicationKey) {
        ApplicationUser loggedInUser = null;
        if (this.jiraAuthenticationContext != null) {
            loggedInUser = this.jiraAuthenticationContext.getLoggedInUser();
        }
        return this.validateRemoveUserFromApplication(loggedInUser, user, applicationKey);
    }

    public UserService.RemoveUserFromApplicationValidationResult validateRemoveUserFromApplication(ApplicationUser loggedInUser, ApplicationUser user, ApplicationKey applicationKey) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"applicationKey", (Object)applicationKey);
        I18nHelper i18nBean = this.getI18nBean(loggedInUser);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (loggedInUser == null || !this.isAdministrator(loggedInUser)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.users.remove.user.to.application.no.permission"));
            return new UserService.RemoveUserFromApplicationValidationResult((ErrorCollection)errors);
        }
        Option applicationRoleOption = this.applicationRoleManager.getRole(applicationKey);
        Set applicationGroupNames = null;
        if (applicationRoleOption.isEmpty()) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.application.not.defined.by.key", (Object)applicationKey));
        } else {
            applicationGroupNames = (Set)((ApplicationRole)applicationRoleOption.get()).getGroups().stream().map(Group::getName).collect(CollectorsUtil.toImmutableSet());
        }
        this.validateGroupsAreWritableInUserDirectory(user, (ErrorCollection)errors);
        this.validateNotRemovingAllAdminGroups(loggedInUser, user, (ErrorCollection)errors, applicationGroupNames);
        if (errors.hasAnyErrors()) {
            return new UserService.RemoveUserFromApplicationValidationResult((ErrorCollection)errors);
        }
        return new UserService.RemoveUserFromApplicationValidationResult(user, applicationGroupNames);
    }

    public void removeUserFromApplication(UserService.RemoveUserFromApplicationValidationResult result) throws RemoveException, PermissionException {
        Assertions.notNull((String)"You can not remove a user from an application with a null validation result.", (Object)result);
        Assertions.is((String)"You can not remove a user from an application with an invalid validation result.", (boolean)result.isValid());
        for (String groupName : result.getApplicationGroupNames()) {
            Group group = this.groupManager.getGroup(groupName);
            if (group == null) continue;
            this.userUtil.removeUserFromGroup(group, result.getUserToRemove());
        }
    }

    private void validateGroupsAreWritableInUserDirectory(ApplicationUser user, ErrorCollection errors) {
        I18nHelper i18nBean = this.jiraAuthenticationContext.getI18nHelper();
        Directory directory = this.userManager.getDirectory(Long.valueOf(user.getDirectoryId()));
        if (!directory.getAllowedOperations().contains(OperationType.CREATE_GROUP)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.directory.fully.read.only", directory.getName()));
        }
    }

    private void dispatchUserCreatedEvent(String username, String email, String displayName, @Nullable Long directoryId, int userEventType, @Nullable ApplicationUser user, boolean shouldSendEmail) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder().put((Object)"username", (Object)username).put((Object)"email", (Object)email).put((Object)"fullname", (Object)displayName);
        if (directoryId != null) {
            mapBuilder.put((Object)"directoryName", (Object)this.userManager.getDirectory(directoryId).getName());
            mapBuilder.put((Object)"directoryId", (Object)directoryId);
        }
        if (this.userManager.canUpdateUserPassword(user)) {
            UserUtil.PasswordResetToken passwordResetToken = this.userUtil.generatePasswordResetToken(user);
            mapBuilder.put((Object)"password.token", (Object)passwordResetToken.getToken());
            mapBuilder.put((Object)"password.hours", (Object)passwordResetToken.getExpiryHours());
        }
        if (shouldSendEmail) {
            mapBuilder.put((Object)"sendEmail", (Object)shouldSendEmail);
        }
        UserEvent event = this.userEventFactory.newUserEventWithExtendedParams((Map<String, Object>)mapBuilder.build(), user, userEventType);
        this.eventPublisher.publish((Object)event);
    }

    private void validateNotRemovingAllAdminGroups(ApplicationUser loggedInUser, ApplicationUser user, ErrorCollection errors, Set<String> applicationGroupNames) {
        I18nHelper i18nBean = this.getI18nBean(loggedInUser);
        if (loggedInUser.equals((Object)user) && applicationGroupNames != null) {
            if (this.globalPermissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, loggedInUser)) {
                if (this.globalPermissionGroupAssociationUtil.isRemovingAllMySysAdminGroups(applicationGroupNames, loggedInUser)) {
                    errors.addErrorMessage(i18nBean.getText("admin.errors.application.cannot.remove.application.last.admin.group"));
                }
            } else if (this.globalPermissionGroupAssociationUtil.isRemovingAllMyAdminGroups(applicationGroupNames, loggedInUser)) {
                errors.addErrorMessage(i18nBean.getText("admin.errors.application.cannot.remove.application.last.admin.group"));
            }
        }
    }
}

