/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.user.search;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.search.query.DirectoryQueries;
import com.atlassian.jira.bc.user.search.DuplicateUserRemovalService;
import com.atlassian.jira.mention.stats.UserSearchServiceStats;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Stopwatch;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicateUserRemovalServiceImpl
implements DuplicateUserRemovalService {
    private static final Logger log = LoggerFactory.getLogger(DuplicateUserRemovalServiceImpl.class);
    private final DirectoryManager directoryManager;
    private final UserSearchServiceStats userSearchServiceStats;

    public DuplicateUserRemovalServiceImpl(DirectoryManager directoryManager, UserSearchServiceStats userSearchServiceStats) {
        this.directoryManager = directoryManager;
        this.userSearchServiceStats = userSearchServiceStats;
    }

    @Override
    @Nonnull
    public List<ApplicationUser> getUniqueSortedApplicationUsers(Collection<ApplicationUser> matchingUsers) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Map<Long, Optional<Integer>> directoryPositions = this.getDirectoryIdToDirectoryPosition();
        Function<ApplicationUser, Integer> directoryPositionForUser = applicationUser -> (Integer)((Optional)directoryPositions.get(applicationUser.getDirectoryId())).orElseThrow(IllegalArgumentException::new);
        Function<ApplicationUser, String> userToLowerUsername = applicationUser -> IdentifierUtils.toLowerCase((String)applicationUser.getUsername());
        Function<ApplicationUser, String> userToLowerDisplayName = applicationUser -> IdentifierUtils.toLowerCase((String)applicationUser.getDisplayName());
        HashSet alreadySeenUsernames = new HashSet();
        AtomicInteger removedDuplicateUsers = new AtomicInteger();
        AtomicInteger removedInactiveDirectoryUsers = new AtomicInteger();
        List<ApplicationUser> deduplicatedUsers = matchingUsers.stream().filter(applicationUser -> {
            Optional directoryPosition = (Optional)directoryPositions.get(applicationUser.getDirectoryId());
            if (!directoryPosition.isPresent()) {
                removedInactiveDirectoryUsers.incrementAndGet();
                log.warn("User '{}' with directoryId={} comes from an inactive directory. This user should have never arrived here.", (Object)applicationUser.getUsername(), (Object)applicationUser.getDirectoryId());
            }
            return directoryPosition.isPresent();
        }).sorted(Comparator.comparing(userToLowerUsername).thenComparing(directoryPositionForUser)).filter(user -> {
            boolean firstTimeSeen = alreadySeenUsernames.add(userToLowerUsername.apply((ApplicationUser)user));
            if (!firstTimeSeen) {
                removedDuplicateUsers.incrementAndGet();
            }
            return firstTimeSeen;
        }).sorted(Comparator.comparing(userToLowerDisplayName).thenComparing(userToLowerUsername)).collect(Collectors.toList());
        int activeDirectories = (int)directoryPositions.values().stream().filter(Optional::isPresent).count();
        log.debug("Filtering list to get unique sorted application users: input={}, output={}", matchingUsers, deduplicatedUsers);
        this.userSearchServiceStats.getUniqueSortedUsers(activeDirectories, directoryPositions.size() - activeDirectories, matchingUsers.size(), deduplicatedUsers.size(), removedInactiveDirectoryUsers.get(), removedDuplicateUsers.get(), stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return deduplicatedUsers;
    }

    private Map<Long, Optional<Integer>> getDirectoryIdToDirectoryPosition() {
        List allDirectories = this.directoryManager.searchDirectories(DirectoryQueries.allDirectories());
        HashMap<Long, Optional<Integer>> directoryIdToPosition = new HashMap<Long, Optional<Integer>>();
        for (int directoryPosition = 0; directoryPosition < allDirectories.size(); ++directoryPosition) {
            Directory directory = (Directory)allDirectories.get(directoryPosition);
            directoryIdToPosition.put(directory.getId(), directory.isActive() ? Optional.of(directoryPosition) : Optional.empty());
        }
        return directoryIdToPosition;
    }
}

