/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.user.search;

import com.atlassian.annotations.Internal;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.jira.bc.user.search.UserId;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizUser;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;

@Internal
public interface UserIndexer {
    public static final String ACTIVE = UserTermKeys.ACTIVE.getPropertyName();
    public static final String INTERNAL_ID = "internal_id";
    public static final String DIRECTORY_ID = "directory_id";
    public static final String DISPLAY_NAME = UserTermKeys.DISPLAY_NAME.getPropertyName();
    public static final String EXACT_DISPLAY_NAME = "exact_" + DISPLAY_NAME;
    public static final String EMAIL = UserTermKeys.EMAIL.getPropertyName();
    public static final String EXACT_EMAIL = "exact_" + EMAIL;
    public static final String USER_NAME = UserTermKeys.USERNAME.getPropertyName();
    public static final String EXACT_USER_NAME = "exact_" + USER_NAME;
    public static final Map<String, String> FIELD_NAME_TO_EXACT_FIELD_NAME_MAP = ImmutableMap.of((Object)DISPLAY_NAME, (Object)EXACT_DISPLAY_NAME, (Object)EMAIL, (Object)EXACT_EMAIL, (Object)USER_NAME, (Object)EXACT_USER_NAME);

    public void index(OfBizUser ... var1);

    public void deindex(UserId ... var1);

    public void deindexById(long ... var1);

    public void deindexByUserName(String ... var1);

    public void replaceAllUsers(Consumer<Consumer<OfBizUser>> var1);

    public List<User> search(Query var1, int var2, int var3, Sort var4);

    public static String exactMatchFieldName(String fieldName) {
        return FIELD_NAME_TO_EXACT_FIELD_NAME_MAP.getOrDefault(fieldName, fieldName);
    }
}

