/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.user.search;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.bc.user.search.UserSearchUtilities;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.util.CharTokenizer;

public class UserNameAnalyzer
extends Analyzer {
    private static final Set<Integer> SEPARATOR_CODE_POINTS = (Set)UserSearchUtilities.SEPARATORS.stream().map(separator -> Character.codePointAt(separator, 0)).collect(CollectorsUtil.toImmutableSet());

    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        CharTokenizer source = new CharTokenizer(){

            protected boolean isTokenChar(int c) {
                return !SEPARATOR_CODE_POINTS.contains(c);
            }
        };
        return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)new LowerCaseFilter((TokenStream)source));
    }
}

