/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.workflow;

import com.atlassian.beehive.ClusterLockService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.bc.workflow.events.WorkflowPublished;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissionHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.ProjectWorkflowSchemeHelper;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowScheme;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.atlassian.jira.workflow.edit.WorkflowStatusesValidator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWorkflowService
implements WorkflowService,
Startable {
    @VisibleForTesting
    static final String OVERWRITE_WORKFLOW_LOCK_NAME = DefaultWorkflowService.class.getName() + ".overwriteWorkflow";
    private static final Logger log = LoggerFactory.getLogger(DefaultWorkflowService.class);
    private final ClusterLockService clusterLockService;
    private final WorkflowManager workflowManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final PermissionManager permissionManager;
    private final WorkflowSchemeManager workflowSchemeManager;
    private final GlobalPermissionManager globalPermissionManager;
    private final EventPublisher eventPublisher;
    private final WorkflowStatusesValidator workflowStatusesValidator;
    private final ProjectWorkflowSchemeHelper projectWorkflowSchemeHelper;
    private final ProjectPermissionHelper projectPermissionHelper;
    private Lock overwriteWorkflowLock;

    public DefaultWorkflowService(WorkflowManager workflowManager, JiraAuthenticationContext jiraAuthenticationContext, PermissionManager permissionManager, WorkflowSchemeManager workflowSchemeManager, ClusterLockService clusterLockService, GlobalPermissionManager globalPermissionManager, EventPublisher eventPublisher, WorkflowStatusesValidator workflowStatusesValidator, ProjectWorkflowSchemeHelper projectWorkflowSchemeHelper, ProjectPermissionHelper projectPermissionHelper) {
        this.clusterLockService = clusterLockService;
        this.workflowManager = workflowManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.permissionManager = permissionManager;
        this.workflowSchemeManager = workflowSchemeManager;
        this.globalPermissionManager = globalPermissionManager;
        this.eventPublisher = eventPublisher;
        this.workflowStatusesValidator = workflowStatusesValidator;
        this.projectWorkflowSchemeHelper = projectWorkflowSchemeHelper;
        this.projectPermissionHelper = projectPermissionHelper;
    }

    public void start() {
        this.overwriteWorkflowLock = this.clusterLockService.getLockForName(OVERWRITE_WORKFLOW_LOCK_NAME);
    }

    public JiraWorkflow getDraftWorkflow(JiraServiceContext jiraServiceContext, String parentWorkflowName) {
        if (StringUtils.isEmpty((CharSequence)parentWorkflowName)) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.no.parent"));
            return null;
        }
        JiraWorkflow parentWorkflow = this.workflowManager.getWorkflow(parentWorkflowName);
        if (parentWorkflow == null) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.retrieve.no.parent"));
            return null;
        }
        if (!this.hasEditWorkflowPermission(jiraServiceContext, parentWorkflowName)) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.no.admin.permission"));
            return null;
        }
        return this.workflowManager.getDraftWorkflow(parentWorkflowName);
    }

    public JiraWorkflow createDraftWorkflow(JiraServiceContext jiraServiceContext, String parentWorkflowName) {
        if (StringUtils.isEmpty((CharSequence)parentWorkflowName)) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.no.parent"));
            return null;
        }
        JiraWorkflow parentWorkflow = this.workflowManager.getWorkflow(parentWorkflowName);
        if (parentWorkflow == null) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.no.parent"));
            return null;
        }
        if (!this.hasEditWorkflowPermission(jiraServiceContext, parentWorkflowName)) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.no.admin.permission"));
            return null;
        }
        if (!this.workflowManager.isActive(parentWorkflow)) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.parent.not.active"));
            return null;
        }
        if (parentWorkflow.isSystemWorkflow()) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.not.editable"));
            return null;
        }
        try {
            return this.workflowManager.createDraftWorkflow(jiraServiceContext.getLoggedInApplicationUser(), parentWorkflowName);
        }
        catch (IllegalStateException e) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.draft.exists.or.workflow.not.active"));
            return null;
        }
    }

    public boolean deleteDraftWorkflow(JiraServiceContext jiraServiceContext, String parentWorkflowName) {
        if (StringUtils.isEmpty((CharSequence)parentWorkflowName)) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.delete.no.parent"));
            return false;
        }
        if (!this.hasEditWorkflowPermission(jiraServiceContext, parentWorkflowName)) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.no.admin.permission"));
            return false;
        }
        return this.workflowManager.deleteDraftWorkflow(parentWorkflowName);
    }

    public ServiceOutcome<Void> deleteWorkflow(ApplicationUser deletingUser, String workflowName) {
        JiraServiceContextImpl jiraServiceContext = new JiraServiceContextImpl(deletingUser);
        JiraWorkflow workflow = this.getWorkflow((JiraServiceContext)jiraServiceContext, workflowName);
        if (jiraServiceContext.getErrorCollection().hasAnyErrors()) {
            return ServiceOutcomeImpl.from(jiraServiceContext.getErrorCollection(), null);
        }
        if (workflow == null) {
            return ServiceOutcomeImpl.error(this.getI18nBean().getText("admin.errors.workflow.with.name.does.not.exist", "'" + workflowName + "'"));
        }
        if (!workflow.isEditable()) {
            return ServiceOutcomeImpl.error(this.getI18nBean().getText("admin.errors.workflow.cannot.be.deleted.as.it.is.not.editable"));
        }
        Iterable workflowSchemes = this.workflowSchemeManager.getSchemesForWorkflowIncludingDrafts(workflow);
        if (!Iterables.isEmpty((Iterable)workflowSchemes)) {
            StringBuilder schemes = new StringBuilder();
            for (WorkflowScheme scheme : workflowSchemes) {
                if (scheme.isDraft()) {
                    schemes.append(this.getI18nBean().getText("admin.workflows.service.workflow.draft.of", scheme.getName()));
                } else {
                    schemes.append('\'').append(scheme.getName()).append('\'');
                }
                schemes.append(", ");
            }
            schemes.delete(schemes.length() - 2, schemes.length() - 1);
            return ServiceOutcomeImpl.error(this.getI18nBean().getText("admin.errors.cannot.delete.this.workflow") + " " + schemes);
        }
        this.workflowManager.deleteWorkflow(workflow);
        return ServiceOutcomeImpl.ok(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void overwriteActiveWorkflow(JiraServiceContext jiraServiceContext, String parentWorkflowName) {
        if (!this.hasEditWorkflowPermission(jiraServiceContext, parentWorkflowName)) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.no.admin.permission"));
            return;
        }
        this.overwriteWorkflowLock.lock();
        try {
            this.validateOverwriteWorkflow(jiraServiceContext, parentWorkflowName);
            if (jiraServiceContext.getErrorCollection().hasAnyErrors()) {
                return;
            }
            boolean isWorkflowIsolated = this.projectWorkflowSchemeHelper.isWorkflowIsolated(parentWorkflowName);
            this.workflowManager.overwriteActiveWorkflow(jiraServiceContext.getLoggedInApplicationUser(), parentWorkflowName);
            this.eventPublisher.publish((Object)this.getWorkflowPublishedEvent(jiraServiceContext, parentWorkflowName, isWorkflowIsolated));
        }
        finally {
            this.overwriteWorkflowLock.unlock();
        }
    }

    private WorkflowPublished getWorkflowPublishedEvent(JiraServiceContext jiraServiceContext, String parentWorkflowName, boolean isWorkflowIsolated) {
        List allProjectsForWorkflow = this.projectWorkflowSchemeHelper.getAllProjectsForWorkflow(parentWorkflowName);
        return new WorkflowPublished(isWorkflowIsolated, this.hasAdminPermission(jiraServiceContext), this.projectPermissionHelper.hasExtPermission(allProjectsForWorkflow), parentWorkflowName, allProjectsForWorkflow.size() == 1 ? ((Project)allProjectsForWorkflow.iterator().next()).getId() : null);
    }

    public void validateOverwriteWorkflow(JiraServiceContext jiraServiceContext, String workflowName) {
        if (StringUtils.isEmpty((CharSequence)workflowName)) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.overwrite.no.parent", workflowName));
            return;
        }
        JiraWorkflow liveJiraWorkflow = this.workflowManager.getWorkflow(workflowName);
        if (liveJiraWorkflow == null) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.overwrite.no.parent", workflowName));
            return;
        }
        if (!liveJiraWorkflow.isActive()) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.overwrite.inactive.parent", workflowName));
            return;
        }
        if (!this.hasEditWorkflowPermission(jiraServiceContext, workflowName)) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.no.admin.permission"));
            return;
        }
        JiraWorkflow draftJiraWorkflow = this.workflowManager.getDraftWorkflow(workflowName);
        if (draftJiraWorkflow == null) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.overwrite.no.draft", workflowName));
            return;
        }
        this.validateOverwriteWorkflow(liveJiraWorkflow, draftJiraWorkflow, jiraServiceContext);
    }

    public void updateWorkflow(JiraServiceContext jiraServiceContext, JiraWorkflow workflow) {
        if (workflow == null || workflow.getDescriptor() == null) {
            this.addError(jiraServiceContext, "admin.workflows.service.error.update.no.workflow", ErrorCollection.Reason.VALIDATION_FAILED);
            return;
        }
        if (!workflow.isEditable()) {
            this.addError(jiraServiceContext, "admin.workflows.service.error.not.editable", ErrorCollection.Reason.VALIDATION_FAILED);
            return;
        }
        if (!this.isWorkflowEditable(jiraServiceContext.getLoggedInApplicationUser(), workflow)) {
            this.addError(jiraServiceContext, "admin.workflows.service.error.no.admin.permission", ErrorCollection.Reason.FORBIDDEN);
            return;
        }
        this.overwriteWorkflowLock.lock();
        try {
            this.workflowManager.updateWorkflow(jiraServiceContext.getLoggedInApplicationUser(), workflow);
        }
        finally {
            this.overwriteWorkflowLock.unlock();
        }
    }

    public void validateUpdateWorkflowNameAndDescription(JiraServiceContext jiraServiceContext, JiraWorkflow currentWorkflow, String newWorkflowName) {
        if (currentWorkflow == null || currentWorkflow.getDescriptor() == null) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.update.no.workflow"));
            return;
        }
        if (!currentWorkflow.isEditable()) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.errors.workflow.cannot.be.edited.as.it.is.not.editable"));
            return;
        }
        if (!this.isWorkflowEditable(jiraServiceContext.getLoggedInApplicationUser(), currentWorkflow)) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.no.admin.permission"));
            return;
        }
        if (currentWorkflow.isDraftWorkflow() && !newWorkflowName.equals(currentWorkflow.getName())) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.edit.name.draft.workflow"));
            return;
        }
        if (!WorkflowUtil.isAcceptableName((String)newWorkflowName, (String)"newWorkflowName", (ErrorCollection)jiraServiceContext.getErrorCollection())) {
            return;
        }
        if (!newWorkflowName.equals(currentWorkflow.getName()) && this.workflowManager.workflowExists(newWorkflowName)) {
            jiraServiceContext.getErrorCollection().addError("newWorkflowName", this.getI18nBean().getText("admin.errors.a.workflow.with.this.name.already.exists"));
            return;
        }
    }

    public void updateWorkflowNameAndDescription(JiraServiceContext jiraServiceContext, JiraWorkflow currentWorkflow, String newName, String newDescription) {
        if (!this.isWorkflowEditable(jiraServiceContext.getLoggedInApplicationUser(), currentWorkflow)) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.no.admin.permission"));
            return;
        }
        this.workflowManager.updateWorkflowNameAndDescription(jiraServiceContext.getLoggedInApplicationUser(), currentWorkflow, newName, newDescription);
    }

    public JiraWorkflow getWorkflow(JiraServiceContext jiraServiceContext, String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.null.name"));
            return null;
        }
        return this.workflowManager.getWorkflow(name);
    }

    public void validateCopyWorkflow(JiraServiceContext jiraServiceContext, String newWorkflowName) {
        if (!this.hasAdminPermission(jiraServiceContext)) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.no.admin.permission"));
            return;
        }
        if (!WorkflowUtil.isAcceptableName((String)newWorkflowName, (String)"newWorkflowName", (ErrorCollection)jiraServiceContext.getErrorCollection())) {
            return;
        }
        try {
            if (this.workflowManager.workflowExists(newWorkflowName)) {
                jiraServiceContext.getErrorCollection().addError("newWorkflowName", this.getI18nBean().getText("admin.errors.a.workflow.with.this.name.already.exists"));
            }
        }
        catch (WorkflowException e) {
            log.error("Error occurred while accessing workflow information.", (Throwable)e);
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.errors.workflows.error.occurred.accessing.information"));
        }
    }

    public JiraWorkflow copyWorkflow(JiraServiceContext jiraServiceContext, String clonedWorkflowName, String clonedWorkflowDescription, JiraWorkflow workflowToClone) {
        WorkflowService.WorkflowPermission workflowPermission = this.getWorkflowPermission(jiraServiceContext.getLoggedInApplicationUser(), workflowToClone);
        boolean isGlobalAdmin = this.hasAdminPermission(jiraServiceContext.getLoggedInApplicationUser());
        boolean isWorkflowEditable = workflowPermission.equals((Object)WorkflowService.WorkflowPermission.EDITABLE);
        boolean isSystemWorkflow = workflowPermission.equals((Object)WorkflowService.WorkflowPermission.SYSTEM_WORKFLOW);
        if (!(isWorkflowEditable || isGlobalAdmin && isSystemWorkflow)) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.no.admin.permission"));
            return null;
        }
        return this.workflowManager.copyWorkflow(jiraServiceContext.getLoggedInApplicationUser(), clonedWorkflowName, clonedWorkflowDescription, workflowToClone);
    }

    public boolean isStepOnDraftWithNoTransitionsOnParentWorkflow(JiraServiceContext jiraServiceContext, JiraWorkflow workflow, int stepId) {
        return false;
    }

    public void validateAddWorkflowTransitionToDraft(JiraServiceContext jiraServiceContext, JiraWorkflow newJiraWorkflow, int stepId) {
        if (!this.isWorkflowEditable(jiraServiceContext.getLoggedInApplicationUser(), newJiraWorkflow)) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.no.admin.permission"));
            return;
        }
    }

    private void validateOverwriteWorkflow(JiraWorkflow oldJiraWorkflow, JiraWorkflow newJiraWorkflow, JiraServiceContext jiraServiceContext) {
        List linkedStatuses = oldJiraWorkflow.getLinkedStatuses();
        ArrayList<StepDescriptor> stepsToDelete = new ArrayList<StepDescriptor>();
        for (GenericValue gvStatus : linkedStatuses) {
            StepDescriptor oldStepDescriptor = oldJiraWorkflow.getLinkedStep(gvStatus);
            StepDescriptor newStepDescriptor = newJiraWorkflow.getLinkedStep(gvStatus);
            if (newStepDescriptor == null) {
                stepsToDelete.add(oldStepDescriptor);
                continue;
            }
            if (oldStepDescriptor.getId() != newStepDescriptor.getId()) {
                jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.overwrite.step.associated.with.wrong.status", String.valueOf(oldStepDescriptor.getId()), gvStatus.getString("name")));
                break;
            }
            this.validateAddWorkflowTransitionToDraft(jiraServiceContext, newJiraWorkflow, oldStepDescriptor.getId());
            if (!jiraServiceContext.getErrorCollection().hasAnyErrors()) continue;
            break;
        }
        for (StepDescriptor stepDescriptor : stepsToDelete) {
            String statusId = (String)stepDescriptor.getMetaAttributes().get("jira.status.id");
            ServiceResult validationResult = this.workflowStatusesValidator.validateStatusDeleteWhenOverwriteWorkflow(this.jiraAuthenticationContext.getLoggedInUser(), oldJiraWorkflow, statusId);
            if (validationResult.isValid()) continue;
            jiraServiceContext.getErrorCollection().addErrorCollection(validationResult.getErrorCollection());
            break;
        }
    }

    @VisibleForTesting
    I18nHelper getI18nBean() {
        return this.jiraAuthenticationContext.getI18nHelper();
    }

    @VisibleForTesting
    boolean hasAdminPermission(JiraServiceContext jiraServiceContext) {
        return this.hasAdminPermission((ApplicationUser)Optional.ofNullable(jiraServiceContext).map(JiraServiceContext::getLoggedInApplicationUser).orElse(null));
    }

    boolean hasAdminPermission(ApplicationUser user) {
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user);
    }

    private void addError(JiraServiceContext jiraServiceContext, String msgKey, ErrorCollection.Reason reason) {
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        errorCollection.addErrorMessage(this.getI18nBean().getText(msgKey));
        errorCollection.addReason(reason);
    }

    private boolean hasEditWorkflowPermission(JiraServiceContext jiraServiceContext, String workflowName) {
        JiraWorkflow workflow = this.workflowManager.getWorkflow(workflowName);
        return this.isWorkflowEditable(Optional.ofNullable(jiraServiceContext).map(JiraServiceContext::getLoggedInApplicationUser).orElse(null), workflow);
    }

    public WorkflowService.WorkflowPermission getWorkflowPermission(ApplicationUser user, JiraWorkflow workflow) {
        if (workflow == null) {
            log.debug("project level admin cannot edit null workflow");
            return WorkflowService.WorkflowPermission.NOT_EDITABLE;
        }
        if (workflow.isSystemWorkflow()) {
            log.debug("noone can edit system workflow {}", (Object)workflow.getName());
            return WorkflowService.WorkflowPermission.SYSTEM_WORKFLOW;
        }
        if (this.hasAdminPermission(user)) {
            return WorkflowService.WorkflowPermission.EDITABLE;
        }
        Iterable schemes = this.workflowSchemeManager.getSchemesForWorkflowIncludingDrafts(workflow);
        if (Iterables.isEmpty((Iterable)schemes)) {
            log.debug("project level admin cannot edit workflow that is not used by any project {}", (Object)workflow.getName());
            return WorkflowService.WorkflowPermission.NOT_EDITABLE;
        }
        int usedInProjectsCount = this.projectWorkflowSchemeHelper.getAllProjectsForWorkflow(workflow.getName()).size();
        if (usedInProjectsCount > 1) {
            log.debug("project level admin cannot edit workflow shared by other projects {}", (Object)workflow.getName());
            return WorkflowService.WorkflowPermission.SHARED;
        }
        if (usedInProjectsCount == 0) {
            log.debug("project level admin cannot edit workflow not used by any project {}", (Object)workflow.getName());
            return WorkflowService.WorkflowPermission.NOT_EDITABLE;
        }
        if (StreamSupport.stream(schemes.spliterator(), false).filter(wf -> wf instanceof AssignableWorkflowScheme).map(wf -> this.workflowSchemeManager.getProjectsUsing((AssignableWorkflowScheme)wf)).flatMap(Collection::stream).allMatch(project -> this.hasExtendedProjectAdminPermission(user, (Project)project))) {
            return WorkflowService.WorkflowPermission.EDITABLE;
        }
        return WorkflowService.WorkflowPermission.NO_PERMISSION;
    }

    public boolean isWorkflowEditable(ApplicationUser applicationUser, JiraWorkflow workflow) {
        return this.getWorkflowPermission(applicationUser, workflow) == WorkflowService.WorkflowPermission.EDITABLE;
    }

    @VisibleForTesting
    boolean hasExtendedProjectAdminPermission(ApplicationUser user, Project project) {
        return ProjectAction.EDIT_PROJECT_CONFIG_EXTENDED.hasPermission(this.permissionManager, user, project);
    }
}

