/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache;

import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.CachedReferenceEvent;
import com.atlassian.cache.CachedReferenceListener;
import java.util.Optional;
import javax.annotation.Nonnull;

public final class ZduCacheMigrationHelper {
    public static <T> CachedReference<T> migrate(CacheFactory cacheManager, String oldCacheName, JiraVersion version, final CachedReference<T> newCache) {
        final CachedReference oldCache = cacheManager.getCachedReference(oldCacheName, Object::new);
        oldCache.addListener(ZduCacheMigrationHelper.invalidationForwarder(newCache), false);
        return new CachedReference<T>(){

            @Nonnull
            public T get() {
                return newCache.get();
            }

            public void reset() {
                newCache.reset();
                oldCache.reset();
            }

            public boolean isPresent() {
                return newCache.isPresent();
            }

            @Nonnull
            public Optional<T> getIfPresent() {
                return newCache.getIfPresent();
            }

            public void addListener(@Nonnull CachedReferenceListener<T> listener, boolean includeValues) {
                newCache.addListener(listener, includeValues);
            }

            public void removeListener(@Nonnull CachedReferenceListener<T> listener) {
                newCache.removeListener(listener);
            }
        };
    }

    private static <T> CachedReferenceListener<Object> invalidationForwarder(final CachedReference<T> newCache) {
        return new CachedReferenceListener<Object>(){

            public void onEvict(@Nonnull CachedReferenceEvent<Object> event) {
                this.reset();
            }

            public void onSet(@Nonnull CachedReferenceEvent<Object> event) {
                this.reset();
            }

            public void onReset(@Nonnull CachedReferenceEvent<Object> event) {
                this.reset();
            }

            private void reset() {
                newCache.reset();
            }
        };
    }

    public static enum JiraVersion {
        JIRA_8_9;

    }
}

