/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache.ehcache.customserialization;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.pico.ContainerNotInitializedException;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.osgi.factory.OsgiPlugin;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.sf.ehcache.util.PreferredLoaderObjectInputStream;

public class CustomSerializedValue
implements Serializable {
    private static final long serialVersionUID = 42L;
    @Nonnull
    private Object value;
    @Nonnull
    private transient String pluginKey;

    CustomSerializedValue(@Nonnull Object value, @Nonnull String pluginKey) {
        Preconditions.checkNotNull((Object)value);
        Preconditions.checkNotNull((Object)pluginKey);
        this.value = value;
        this.pluginKey = pluginKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomSerializedValue that = (CustomSerializedValue)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.pluginKey);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(out);
        objectOutputStream.writeObject(this.value);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.pluginKey = (String)in.readObject();
        Preconditions.checkNotNull((Object)this.pluginKey, (Object)"Plugin key is null");
        PluginAccessor pluginAccessor = (PluginAccessor)ComponentAccessor.getComponentSafely(PluginAccessor.class).orElseThrow(() -> new ContainerNotInitializedException("Couldn't access PluginAccessor using ComponentAccessor"));
        OsgiPlugin plugin = (OsgiPlugin)pluginAccessor.getPlugin(this.pluginKey);
        Preconditions.checkNotNull((Object)plugin, (Object)("Couldn't acquire plugin from PluginAccessor, plugin key: " + this.pluginKey));
        ClassLoader pluginClassLoader = plugin.getClassLoader();
        Preconditions.checkNotNull((Object)pluginClassLoader, (Object)("Plugin ClassLoader is not present, plugin key: " + this.pluginKey));
        PreferredLoaderObjectInputStream objectInputStream = new PreferredLoaderObjectInputStream((InputStream)in, pluginClassLoader);
        this.value = objectInputStream.readObject();
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isValueSerializable() {
        return this.value instanceof Serializable;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CustomSerializedValue{");
        sb.append("value=").append(this.value);
        sb.append(", isValueSerializable='").append(this.isValueSerializable()).append('\'');
        sb.append(", pluginKey='").append(this.pluginKey).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

