/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache.ehcache.customserialization;

import com.atlassian.cache.ehcache.wrapper.ValueProcessor;
import com.atlassian.jira.cache.ehcache.customserialization.CustomSerializedValue;
import com.atlassian.plugin.osgi.util.OsgiHeaderUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomSerializedValueProcessor
implements ValueProcessor {
    private static final Logger log = LoggerFactory.getLogger(CustomSerializedValue.class);

    public Object wrap(Object t) {
        if (t != null && t.getClass().getClassLoader() != null && t.getClass().getClassLoader() != CustomSerializedValueProcessor.class.getClassLoader()) {
            String pluginKey = this.getPluginKey(t);
            if (pluginKey != null) {
                return new CustomSerializedValue(t, pluginKey);
            }
            log.debug("Couldn't find plugin key for a class defined outside of JIRA Core. Class: {}", t.getClass());
        }
        return t;
    }

    private <T> String getPluginKey(T t) {
        Bundle bundle = FrameworkUtil.getBundle(t.getClass());
        if (bundle != null) {
            return OsgiHeaderUtil.getPluginKey((Bundle)bundle);
        }
        return null;
    }

    public Object unwrap(Object t) {
        return t != null && t instanceof CustomSerializedValue ? ((CustomSerializedValue)t).getValue() : t;
    }
}

