/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache.request;

import com.atlassian.jira.cache.request.RequestCacheImpl;
import com.atlassian.jira.cache.request.RequestCacheRecorder;
import com.atlassian.jira.util.thread.JiraThreadLocalUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestCacheRecorderImpl
implements RequestCacheRecorder {
    private final Set<String> threadsThatUsedRequestCacheWrong = Collections.synchronizedSet(new HashSet());
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void recordRequestCacheOOCUsage(String threadName) {
        String baseThreadName = this.getBaseThreadName(threadName);
        if (!this.threadsThatUsedRequestCacheWrong.contains(baseThreadName)) {
            this.threadsThatUsedRequestCacheWrong.add(baseThreadName);
            this.errorLogOOCThreadUsage(baseThreadName);
        }
        this.traceLogOOCThreadUsage(threadName);
    }

    private void errorLogOOCThreadUsage(String baseThreadName) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(String.format("Invalid use of RequestCache by thread: %s.Incorrect usage of JIRA API. You can only create/use: %s inside a context (request or Jira-Thread-Local). Check: %s for details. This message will be logged once per thread. This ERROR should be fixed on the caller side (check the stack-trace or thread-name) as it is causing inconsistent data.", baseThreadName, RequestCacheImpl.class.getSimpleName(), JiraThreadLocalUtil.class.getSimpleName()), new Throwable());
        }
    }

    private void traceLogOOCThreadUsage(String threadName) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(String.format("Invalid use of RequestCache by thread: %s.Incorrect usage of JIRA API. You can only create/use: %s inside a context (request or Jira-Thread-Local). Check: %s for details.", threadName, RequestCacheImpl.class.getSimpleName(), JiraThreadLocalUtil.class.getSimpleName()), new Throwable());
        }
    }

    private String getBaseThreadName(String threadName) {
        String baseThreadName = "";
        int spaceIndex = threadName.indexOf(" ");
        baseThreadName = spaceIndex > -1 ? threadName.substring(0, spaceIndex) : threadName;
        int lastDashIndex = baseThreadName.lastIndexOf("-");
        if (lastDashIndex > -1) {
            baseThreadName = baseThreadName.substring(0, lastDashIndex);
        }
        return baseThreadName;
    }
}

