/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache.serialcheck;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheEntryListener;
import com.atlassian.cache.Supplier;
import com.atlassian.jira.cache.serialcheck.SerializationRecorder;
import java.io.IOException;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class SerializationRecordingCache<K, V>
implements Cache<K, V> {
    private static final Logger log = LoggerFactory.getLogger(SerializationRecordingCache.class);
    private final Cache<K, V> delegate;
    private final SerializationRecorder recorder;
    private final boolean includeValues;

    public SerializationRecordingCache(Cache<K, V> delegate, SerializationRecorder recorder, boolean includeValues) {
        this.delegate = delegate;
        this.recorder = recorder;
        this.includeValues = includeValues;
    }

    @Nonnull
    public String getName() {
        return this.delegate.getName();
    }

    public boolean containsKey(K key) {
        return this.delegate.containsKey(key);
    }

    @Nonnull
    public Collection<K> getKeys() {
        return this.delegate.getKeys();
    }

    @Nullable
    public V get(K key) {
        return (V)this.delegate.get(key);
    }

    @Nonnull
    public V get(K key, Supplier<? extends V> supplier) {
        this.record(key);
        return (V)this.delegate.get(key, supplier);
    }

    public void put(K key, V value) {
        this.record(key, value);
        this.delegate.put(key, value);
    }

    @Nullable
    public V putIfAbsent(K key, V value) {
        this.record(key, value);
        return (V)this.delegate.putIfAbsent(key, value);
    }

    public void remove(K key) {
        this.record(key);
        this.delegate.remove(key);
    }

    public boolean remove(K key, V value) {
        this.record(key);
        return this.delegate.remove(key, value);
    }

    public void removeAll() {
        this.delegate.removeAll();
    }

    public boolean replace(K key, V oldValue, V newValue) {
        this.record(key, newValue);
        return this.delegate.replace(key, oldValue, newValue);
    }

    public void addListener(CacheEntryListener<K, V> listener, boolean includeValues) {
        this.delegate.addListener(listener, includeValues);
    }

    public void removeListener(CacheEntryListener<K, V> cacheEntryListener) {
        this.delegate.removeListener(cacheEntryListener);
    }

    private void record(K key) {
        this.record(key, null);
    }

    private void record(K key, @Nullable V value) {
        if (!this.includeValues) {
            value = null;
        }
        try {
            this.recorder.record(this.getName(), key, value);
        }
        catch (IOException e) {
            log.error("Error recording cache entry for " + this.getName() + ": " + key + ": " + e, (Throwable)e);
        }
    }
}

