/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache.serialcheck;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.ManagedCache;
import com.atlassian.cache.Supplier;
import com.atlassian.jira.cache.serialcheck.DefaultSerializationRecorder;
import com.atlassian.jira.cache.serialcheck.SerializationRecorder;
import com.atlassian.jira.cache.serialcheck.SerializationRecordingCache;
import com.atlassian.jira.cache.serialcheck.SerializationRecordingCachedReference;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class SerializationRecordingCacheManager
implements CacheManager {
    private static final Logger log = LoggerFactory.getLogger(SerializationRecordingCacheManager.class);
    private final CacheManager delegate;
    private final SerializationRecorder recorder;

    public SerializationRecordingCacheManager(CacheManager delegate, final Path recordFile) throws IOException {
        this(delegate, new DefaultSerializationRecorder(recordFile){

            @Override
            public synchronized void close() throws IOException {
                super.close();
                log.info("Serialization recording file size " + Files.size(recordFile) + ": " + recordFile.toAbsolutePath());
            }
        });
    }

    public SerializationRecordingCacheManager(CacheManager delegate, SerializationRecorder recorder) {
        this.delegate = delegate;
        this.recorder = recorder;
    }

    @Deprecated
    @Nonnull
    public Collection<Cache<?, ?>> getCaches() {
        return this.delegate.getCaches();
    }

    @Nonnull
    public Collection<ManagedCache> getManagedCaches() {
        return this.delegate.getManagedCaches();
    }

    public void flushCaches() {
        this.delegate.flushCaches();
    }

    @Nullable
    public ManagedCache getManagedCache(@Nonnull String name) {
        return this.delegate.getManagedCache(name);
    }

    public void shutdown() {
        try {
            this.recorder.close();
        }
        catch (IOException e) {
            log.error("Error closing cache record stream: " + e, (Throwable)e);
        }
        this.delegate.shutdown();
    }

    @Nonnull
    public <V> CachedReference<V> getCachedReference(@Nonnull String name, @Nonnull Supplier<V> supplier) {
        CachedReference ref = this.delegate.getCachedReference(name, supplier);
        return this.wrapIfNecessary(name, ref);
    }

    @Nonnull
    public <V> CachedReference<V> getCachedReference(String name, Supplier<V> supplier, CacheSettings cacheSettings) {
        CachedReference ref = this.delegate.getCachedReference(name, supplier, cacheSettings);
        return this.wrapIfNecessary(name, ref, cacheSettings);
    }

    @Nonnull
    public <V> CachedReference<V> getCachedReference(Class<?> owningClass, String name, Supplier<V> supplier) {
        CachedReference ref = this.delegate.getCachedReference(owningClass, name, supplier);
        return this.wrapIfNecessary(name, ref);
    }

    @Nonnull
    public <V> CachedReference<V> getCachedReference(Class<?> owningClass, String name, Supplier<V> supplier, CacheSettings cacheSettings) {
        CachedReference ref = this.delegate.getCachedReference(owningClass, name, supplier, cacheSettings);
        return this.wrapIfNecessary(name, ref, cacheSettings);
    }

    @Nonnull
    public <K, V> Cache<K, V> getCache(String name) {
        Cache ref = this.delegate.getCache(name);
        return this.wrapIfNecessary(name, ref);
    }

    @Nonnull
    public <K, V> Cache<K, V> getCache(Class<?> owningClass, String name) {
        Cache ref = this.delegate.getCache(owningClass, name);
        return this.wrapIfNecessary(name, ref);
    }

    @Nonnull
    public <K, V> Cache<K, V> getCache(String name, @Nullable CacheLoader<K, V> cacheLoader) {
        Cache ref = this.delegate.getCache(name, cacheLoader);
        return this.wrapIfNecessary(name, ref);
    }

    @Nonnull
    public <K, V> Cache<K, V> getCache(String name, @Nullable CacheLoader<K, V> cacheLoader, CacheSettings cacheSettings) {
        Cache ref = this.delegate.getCache(name, cacheLoader, cacheSettings);
        return this.wrapIfNecessary(name, ref, cacheSettings);
    }

    @Deprecated
    @Nonnull
    public <K, V> Cache<K, V> getCache(String name, Class<K> keyClass, Class<V> valueClass) {
        Cache ref = this.delegate.getCache(name, keyClass, valueClass);
        return this.wrapIfNecessary(name, ref);
    }

    private <T> CachedReference<T> wrapIfNecessary(String name, CachedReference<T> delegate) {
        return this.wrapIfNecessary(name, delegate, null);
    }

    private <T> CachedReference<T> wrapIfNecessary(String name, CachedReference<T> delegate, @Nullable CacheSettings settings) {
        boolean includeValues;
        boolean bl = includeValues = settings != null && !Boolean.TRUE.equals(settings.getLocal()) && Boolean.TRUE.equals(settings.getReplicateViaCopy());
        if (includeValues) {
            return new SerializationRecordingCachedReference<T>(name, delegate, this.recorder);
        }
        return delegate;
    }

    private <K, V> Cache<K, V> wrapIfNecessary(String name, Cache<K, V> delegate) {
        return this.wrapIfNecessary(name, delegate, null);
    }

    private <K, V> Cache<K, V> wrapIfNecessary(String name, Cache<K, V> delegate, @Nullable CacheSettings settings) {
        boolean includeValues = settings != null && !Boolean.TRUE.equals(settings.getLocal()) && Boolean.TRUE.equals(settings.getReplicateViaCopy());
        return new SerializationRecordingCache<K, V>(delegate, this.recorder, includeValues);
    }
}

