/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.charts;

import com.atlassian.core.util.DateUtils;
import com.atlassian.jira.charts.Chart;
import com.atlassian.jira.charts.ChartFactory;
import com.atlassian.jira.charts.jfreechart.ChartHelper;
import com.atlassian.jira.charts.jfreechart.HistogramChartGenerator;
import com.atlassian.jira.charts.jfreechart.util.ChartUtil;
import com.atlassian.jira.charts.util.ChartUtils;
import com.atlassian.jira.charts.util.DataUtils;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchQuery;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.query.Query;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.SimpleCollector;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

class AverageAgeChart {
    private final SearchProvider searchProvider;
    private final TimeZone chartTimeZone;

    public AverageAgeChart(SearchProvider searchProvider, TimeZone chartTimeZone) {
        this.searchProvider = searchProvider;
        this.chartTimeZone = chartTimeZone;
    }

    public Chart generateChart(ApplicationUser remoteUser, SearchRequest searchRequest, int days, ChartFactory.PeriodName periodName, int width, int height) {
        return this.generateChartInternal(remoteUser, searchRequest, days, periodName, width, height, false);
    }

    public Chart generateInlineChart(ApplicationUser remoteUser, SearchRequest searchRequest, int days, ChartFactory.PeriodName periodName, int width, int height) {
        return this.generateChartInternal(remoteUser, searchRequest, days, periodName, width, height, true);
    }

    private Chart generateChartInternal(ApplicationUser remoteUser, SearchRequest searchRequest, int days, ChartFactory.PeriodName periodName, int width, int height, boolean inline) {
        Assertions.notNull((String)"searchRequest", (Object)searchRequest);
        days = DataUtils.normalizeDaysValue((int)days, (ChartFactory.PeriodName)periodName);
        try {
            SearchRequest clonedSr = this.getModifiedSearchRequest(searchRequest, days);
            TimeSeriesCollection dataset = this.getAverageAge(clonedSr, remoteUser, periodName, days);
            I18nBean i18nBean = this.getI18n(remoteUser);
            TimeSeriesCollection chartDataset = DataUtils.reduceDataset((TimeSeriesCollection)dataset, (List)Lists.newArrayList((Object[])new String[]{i18nBean.getText("datacollector.averageage")}));
            ChartHelper helper = new HistogramChartGenerator(chartDataset, i18nBean.getText("datacollector.days"), i18nBean).generateChart();
            JFreeChart chart = helper.getChart();
            XYPlot plot = (XYPlot)chart.getPlot();
            XYBarRenderer renderer = (XYBarRenderer)plot.getRenderer();
            renderer.setToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator("{1}: {2} " + i18nBean.getText("datacollector.daysunresolved"), (DateFormat)new SimpleDateFormat("dd-MMMMM-yyyy", i18nBean.getLocale()), NumberFormat.getInstance()));
            plot.setRenderer((XYItemRenderer)renderer);
            if (inline) {
                helper.generateInline(width, height);
            } else {
                helper.generate(width, height);
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("chart", helper.getLocation());
            params.put("chartDataset", chartDataset);
            params.put("completeDataset", dataset);
            params.put("daysPrevious", days);
            params.put("period", periodName.toString());
            params.put("imagemap", helper.getImageMap());
            params.put("imagemapName", helper.getImageMapName());
            if (inline) {
                String base64Image = ((ChartUtils)ComponentAccessor.getComponent(ChartUtils.class)).renderBase64Chart(helper.getImage(), "Average Age Chart");
                params.put("base64Image", base64Image);
            }
            return new Chart(helper.getLocation(), helper.getImageMap(), helper.getImageMapName(), params);
        }
        catch (SearchException | IOException e) {
            throw new RuntimeException("Error generating chart", e);
        }
    }

    public TimeSeriesCollection getAverageAge(SearchRequest searchRequest, ApplicationUser remoteUser, ChartFactory.PeriodName periodName, int days) throws SearchException {
        Class timePeriodClass = ChartUtil.getTimePeriodClass((ChartFactory.PeriodName)periodName);
        Query query = searchRequest != null ? searchRequest.getQuery() : null;
        AverageAgeHitCollector averageAgeHitCollector = new AverageAgeHitCollector(timePeriodClass, days, this.getCurrentTime(), this.chartTimeZone);
        this.searchProvider.search(SearchQuery.create((Query)query, (ApplicationUser)remoteUser), (Collector)averageAgeHitCollector);
        Map<RegularTimePeriod, Long> ageTotals = averageAgeHitCollector.getAgeTotals();
        Map<RegularTimePeriod, Long> ageCounts = averageAgeHitCollector.getAgeCounts();
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        I18nBean i18nBean = this.getI18n(remoteUser);
        TimeSeries countSeries = new TimeSeries((Comparable)((Object)i18nBean.getText("datacollector.issuesunresolvedcapital")), timePeriodClass);
        TimeSeries totalSeries = new TimeSeries((Comparable)((Object)i18nBean.getText("datacollector.totalage")), timePeriodClass);
        TimeSeries averageSeries = new TimeSeries((Comparable)((Object)i18nBean.getText("datacollector.averageage")), timePeriodClass);
        for (RegularTimePeriod period : ageTotals.keySet()) {
            Long ageTotalLong = ageTotals.get(period);
            long total = ageTotals.get(period) == null ? 0L : ageTotalLong;
            Long ageCountLong = ageCounts.get(period);
            long count = ageCountLong == null ? 0L : ageCountLong;
            long average = 0L;
            if (count > 0L) {
                average = total / count;
            }
            countSeries.add(period, (double)count);
            totalSeries.add(period, (double)(total / DateUtils.DAY_MILLIS));
            averageSeries.add(period, (double)(average / DateUtils.DAY_MILLIS));
        }
        dataset.addSeries(countSeries);
        dataset.addSeries(totalSeries);
        dataset.addSeries(averageSeries);
        return dataset;
    }

    protected long getCurrentTime() {
        return System.currentTimeMillis();
    }

    private SearchRequest getModifiedSearchRequest(SearchRequest searchRequest, int days) {
        JqlQueryBuilder queryBuilder = JqlQueryBuilder.newBuilder((Query)searchRequest.getQuery());
        queryBuilder.where().defaultAnd().sub().resolutionDate().gtEq().string("-" + days + "d").or().unresolved().endsub();
        return new SearchRequest(queryBuilder.buildQuery());
    }

    I18nBean getI18n(ApplicationUser user) {
        return new I18nBean(user);
    }

    static class AverageAgeHitCollector
    extends SimpleCollector {
        private final RegularTimePeriod[] cursors;
        private final long[] starts;
        private final long[] ends;
        private final long[] totalTimes;
        private final long[] totalCounts;
        private NumericDocValues createdDateDocValues;
        private NumericDocValues resolvedDateDocValues;
        private boolean matchedAtLeastOneDoc = false;

        public AverageAgeHitCollector(Class timePeriodClass, int days, long currentTime, TimeZone timeZone) {
            Calendar cal = Calendar.getInstance(timeZone);
            cal.setTimeInMillis(currentTime);
            cal.add(5, -(days - 1));
            Date earliest = cal.getTime();
            RegularTimePeriod end = RegularTimePeriod.createInstance((Class)timePeriodClass, (Date)new Date(currentTime), (TimeZone)timeZone);
            this.cursors = this.generateCursors(RegularTimePeriod.createInstance((Class)timePeriodClass, (Date)earliest, (TimeZone)timeZone), end, cal);
            this.starts = new long[this.cursors.length];
            this.ends = new long[this.cursors.length];
            this.totalTimes = new long[this.cursors.length];
            this.totalCounts = new long[this.cursors.length];
            for (int i = 0; i < this.cursors.length; ++i) {
                RegularTimePeriod cursor = this.cursors[i];
                long cursorStart = cursor.getFirstMillisecond();
                long endDate = cursor.getLastMillisecond();
                if (currentTime < endDate) {
                    endDate = currentTime;
                }
                this.starts[i] = cursorStart;
                this.ends[i] = endDate;
            }
        }

        private RegularTimePeriod[] generateCursors(RegularTimePeriod start, RegularTimePeriod end, Calendar cal) {
            ArrayList<RegularTimePeriod> cursors = new ArrayList<RegularTimePeriod>();
            for (RegularTimePeriod cursor = start; cursor != null && cursor.compareTo((Object)end) <= 0; cursor = cursor.next()) {
                cursors.add(cursor);
                cursor.peg(cal);
            }
            return cursors.toArray(new RegularTimePeriod[0]);
        }

        public void doSetNextReader(LeafReaderContext context) throws IOException {
            this.createdDateDocValues = context.reader().getNumericDocValues("created");
            this.resolvedDateDocValues = context.reader().getNumericDocValues("resolutiondate");
        }

        public boolean needsScores() {
            return false;
        }

        public void collect(int doc) throws IOException {
            this.matchedAtLeastOneDoc = true;
            Long creationDate = this.getDateOrNull(doc, this.createdDateDocValues);
            Long resolutionDate = this.getDateOrNull(doc, this.resolvedDateDocValues);
            if (creationDate != null) {
                this.addTimesToBuckets(creationDate, resolutionDate != null ? resolutionDate : Long.MAX_VALUE);
            }
        }

        private Long getDateOrNull(int doc, NumericDocValues docValues) throws IOException {
            if (docValues != null && docValues.advanceExact(doc)) {
                return docValues.longValue();
            }
            return null;
        }

        private void addTimesToBuckets(long creationTime, long resolutionTime) {
            int from;
            for (int i = from = AverageAgeHitCollector.findFirstGreaterOrEqual(creationTime, this.ends); i < this.ends.length && resolutionTime >= this.starts[i]; ++i) {
                int n = i;
                this.totalCounts[n] = this.totalCounts[n] + 1L;
                int n2 = i;
                this.totalTimes[n2] = this.totalTimes[n2] + (Math.min(resolutionTime, this.ends[i]) - creationTime);
            }
        }

        private static int findFirstGreaterOrEqual(long value, long[] values) {
            int position = Arrays.binarySearch(values, value);
            return position < 0 ? -position - 1 : position;
        }

        Map<RegularTimePeriod, Long> getAgeTotals() {
            return this.matchedAtLeastOneDoc ? AverageAgeHitCollector.mapFromKeysAndValues(this.cursors, this.totalTimes) : Collections.emptyMap();
        }

        Map<RegularTimePeriod, Long> getAgeCounts() {
            return this.matchedAtLeastOneDoc ? AverageAgeHitCollector.mapFromKeysAndValues(this.cursors, this.totalCounts) : Collections.emptyMap();
        }

        private static Map<RegularTimePeriod, Long> mapFromKeysAndValues(RegularTimePeriod[] keys, long[] values) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < keys.length; ++i) {
                builder.put((Object)keys[i], (Object)values[i]);
            }
            return builder.build();
        }
    }
}

