/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.charts.piechart;

import com.atlassian.jira.charts.PieChart;
import com.atlassian.jira.charts.PieSegmentWrapper;
import com.atlassian.jira.charts.jfreechart.util.PieDatasetUtil;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.statistics.FilterStatisticsValuesGenerator;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.bean.StatisticMap;
import java.util.Map;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PieChartDataSetFactory {
    private static final double DEFAULT_CONSOLIDATION_MINIMUM_PERCENTAGE_THRESHOLD = 0.02;
    private static final int DEFAULT_CONSOLIDATION_MINIMUM_COUNT_THRESHOLD = 10;
    private static final Logger log = LoggerFactory.getLogger(PieChart.class);
    private final ConstantsManager constantsManager;
    private final CustomFieldManager customFieldManager;
    private final StatisticMap<?, Number> statisticMap;
    private final I18nHelper i18nHelper;
    private final String statisticType;
    private final double consolidationMinimumPercentThreshold = 0.02;
    private final int consolidationMinimumCountThreshold = 10;

    public PieChartDataSetFactory(ConstantsManager constantsManager, CustomFieldManager customFieldManager, StatisticMap<?, Number> statisticMap, I18nHelper i18nHelper, String statisticType) {
        this.constantsManager = (ConstantsManager)Assertions.notNull((Object)constantsManager);
        this.customFieldManager = (CustomFieldManager)Assertions.notNull((Object)customFieldManager);
        this.statisticMap = (StatisticMap)Assertions.notNull(statisticMap);
        this.i18nHelper = (I18nHelper)Assertions.notNull((Object)i18nHelper);
        this.statisticType = (String)Assertions.notNull((Object)statisticType);
    }

    public PieDataset createSortedPieDataset() {
        log.debug("DataCollector.populatePieChart: Creating initial PieDataset.");
        PieDataset dataset = this.createRawPieDataset();
        log.debug("DataCollector.populatePieChart: Processing the PieDataset.");
        return PieDatasetUtil.createSortedPieDataset((PieDataset)dataset);
    }

    PieDataset createRawPieDataset() {
        DefaultPieDataset dataset = new DefaultPieDataset();
        for (Map.Entry statistic : this.statisticMap.entrySet()) {
            PieSegmentWrapper pieSegmentWrapper = new PieSegmentWrapper(statistic.getKey(), this.i18nHelper, this.statisticType, this.constantsManager, this.customFieldManager);
            dataset.setValue((Comparable)pieSegmentWrapper, (Number)statistic.getValue());
        }
        if (this.statisticMap.getIrrelevantCount() > 0) {
            PieSegmentWrapper pieSegmentWrapper = new PieSegmentWrapper(FilterStatisticsValuesGenerator.IRRELEVANT, this.i18nHelper, this.statisticType, this.constantsManager, this.customFieldManager);
            Integer number = this.statisticMap.getIrrelevantCount();
            dataset.setValue((Comparable)pieSegmentWrapper, (Number)number);
        }
        return dataset;
    }

    public CategoryDataset createCategoryDataset(long numIssues, PieDataset pieDataset) {
        DefaultCategoryDataset completeDataset = new DefaultCategoryDataset();
        for (Object o : pieDataset.getKeys()) {
            Comparable key = (Comparable)o;
            Number value = pieDataset.getValue(key);
            long percentage = (long)(100 * value.intValue()) / numIssues;
            completeDataset.addValue(value, (Comparable)((Object)this.i18nHelper.getText("common.concepts.issues")), key);
            completeDataset.addValue((double)percentage, (Comparable)((Object)"%"), key);
        }
        return completeDataset;
    }

    public PieDataset createConsolidatedPieDataset(PieDataset sortedPieDataset, Comparable otherSegmentKey) {
        return PieDatasetUtil.createConsolidatedSortedPieDataset((PieDataset)sortedPieDataset, (Comparable)otherSegmentKey, (boolean)false, (double)0.02, (int)10);
    }
}

