/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster;

import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterSettings {
    private static final Logger log = LoggerFactory.getLogger(ClusterSettings.class);
    public static final Duration DEFAULT_RETENTION_PERIOD = Duration.ofDays(2L);
    public static final String CLUSTER_RETENTION_PERIOD_IN_DAYS_SYSTEM_PROPERTY_KEY = "jira.cluster.retention.period.in.days";
    public static final String NOT_ALIVE_ACTIVE_NODES_RETENTION_PERIOD_IN_HOURS_SYSTEM_PROPERTY_KEY = "jira.not.alive.active.nodes.retention.period.in.hours";

    private ClusterSettings() {
    }

    public static Duration getClusterRetentionPeriod() {
        return ClusterSettings.getProperty(CLUSTER_RETENTION_PERIOD_IN_DAYS_SYSTEM_PROPERTY_KEY, DEFAULT_RETENTION_PERIOD.toDays(), ChronoUnit.DAYS);
    }

    public static Duration getNotAliveNodeRetentionPeriod() {
        Duration clusterRetentionPeriod = ClusterSettings.getClusterRetentionPeriod();
        return ClusterSettings.getProperty(NOT_ALIVE_ACTIVE_NODES_RETENTION_PERIOD_IN_HOURS_SYSTEM_PROPERTY_KEY, clusterRetentionPeriod.toHours(), ChronoUnit.HOURS);
    }

    private static Duration getProperty(String propertyKey, long defaultPropertyValue, TemporalUnit timeUnit) {
        JiraProperties jiraProperties = JiraSystemProperties.getInstance();
        long notParsedPropertyValue = jiraProperties.getLong(propertyKey, Long.valueOf(defaultPropertyValue));
        if (notParsedPropertyValue < 1L) {
            Duration defaultValue = Duration.of(defaultPropertyValue, timeUnit);
            log.warn("{} {} system property is negative. Jira sets the value to default one: {}", new Object[]{"[CLUSTER-STATE]", propertyKey, defaultValue});
            return defaultValue;
        }
        Duration propertyValue = Duration.of(notParsedPropertyValue, timeUnit);
        log.info("{} Value for system property key {} was set to {} ", new Object[]{"[CLUSTER-STATE]", propertyKey, propertyValue});
        return propertyValue;
    }
}

