/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster;

import com.atlassian.jira.auditing.handlers.ClusterNodeAuditHandler;
import com.atlassian.jira.cluster.ClusterNodeProperties;
import com.atlassian.jira.cluster.ClusterNodes;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.cluster.ClusterStateException;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.cluster.OfBizClusterNodeStore;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.JiraUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClusterNodes
implements ClusterNodes {
    private static final Logger log = LoggerFactory.getLogger(DefaultClusterNodes.class);
    @ClusterSafe
    private final ResettableLazyReference<Node> nodeRef = new ResettableLazyReference<Node>(){

        protected Node create() {
            return DefaultClusterNodes.this.initializeNode();
        }
    };
    private final ClusterNodeProperties clusterNodeProperties;
    private final OfBizClusterNodeStore ofBizClusterNodeStore;
    private final String hostname;
    private final long nodeBuildNumber;
    private final String nodeVersion;
    private final Supplier<Set<Node>> allNodes;
    private final ClusterNodeAuditHandler clusterNodeAuditHandler;

    public DefaultClusterNodes(ClusterNodeProperties clusterNodeProperties, OfBizClusterNodeStore ofBizClusterNodeStore, BuildUtilsInfo buildUtilsInfo, ClusterNodeAuditHandler clusterNodeAuditHandler) {
        this.clusterNodeProperties = clusterNodeProperties;
        this.ofBizClusterNodeStore = ofBizClusterNodeStore;
        this.hostname = this.buildHostname();
        this.nodeBuildNumber = buildUtilsInfo.getApplicationBuildNumber();
        this.nodeVersion = buildUtilsInfo.getVersion();
        this.allNodes = Suppliers.memoizeWithExpiration(() -> ImmutableSet.copyOf(ofBizClusterNodeStore.getAllNodes()), (long)1L, (TimeUnit)TimeUnit.SECONDS);
        this.clusterNodeAuditHandler = clusterNodeAuditHandler;
    }

    @Override
    public Node current() {
        return (Node)this.nodeRef.get();
    }

    @Override
    public void reset() {
        this.nodeRef.reset();
    }

    @Override
    public Set<Node> all() {
        return (Set)this.allNodes.get();
    }

    @Override
    @Nullable
    public Node node(String nodeId) {
        return ((Set)this.allNodes.get()).stream().filter(node -> nodeId.equals(node.getNodeId())).findAny().orElse(null);
    }

    Node initializeNode() {
        String nodeId = this.clusterNodeProperties.getNodeId();
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            return Node.NOT_CLUSTERED;
        }
        return this.getOrCreateNode(nodeId);
    }

    private Node getOrCreateNode(String nodeId) {
        Node node = this.ofBizClusterNodeStore.getNode(nodeId);
        if (node == null) {
            node = this.ofBizClusterNodeStore.createNode(nodeId, Node.NodeState.ACTIVE, this.hostname, this.getCacheListenerPort(), this.nodeBuildNumber, this.nodeVersion);
            this.clusterNodeAuditHandler.handleNodeAdded(node, this.ofBizClusterNodeStore.getAllNodes());
        } else if (this.stateHasChanged(node)) {
            Node nodeOld = node;
            node = this.ofBizClusterNodeStore.updateNode(nodeId, Node.NodeState.ACTIVE, this.hostname, this.getCacheListenerPort(), this.nodeBuildNumber, this.nodeVersion);
            this.clusterNodeAuditHandler.handleNodeReactivated(node, nodeOld, this.ofBizClusterNodeStore.getAllNodes());
        }
        return node;
    }

    protected boolean stateHasChanged(Node node) {
        return node.getState() == Node.NodeState.OFFLINE || !StringUtils.equalsIgnoreCase((CharSequence)this.hostname, (CharSequence)node.getIp()) || !Objects.equal((Object)node.getCacheListenerPort(), (Object)this.getCacheListenerPort()) || !Objects.equal((Object)node.getNodeBuildNumber(), (Object)this.nodeBuildNumber) || !Objects.equal((Object)node.getNodeVersion(), (Object)this.nodeVersion);
    }

    protected Long getCacheListenerPort() {
        String port = this.clusterNodeProperties.getProperty("ehcache.listener.port");
        return Long.valueOf(port != null ? port : "40001");
    }

    @VisibleForTesting
    protected String buildHostname() {
        String hostname = this.clusterNodeProperties.getProperty("ehcache.listener.hostName");
        return hostname != null ? hostname : JiraUtils.getHostname();
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public void removeIfOffline(@NotNull String nodeId) throws ClusterStateException {
        Node node = this.node(nodeId);
        if (node != null) {
            if (node.getState() != Node.NodeState.OFFLINE) {
                throw new ClusterStateException("You can only remove offline node");
            }
        } else {
            throw new ClusterStateException("You can only remove not null node");
        }
        this.removeNode(node);
        log.info("{} Node {} has been removed from the cluster.", (Object)"[CLUSTER-STATE]", (Object)nodeId);
    }

    private void removeNode(@NotNull Node node) throws ClusterStateException {
        try {
            if (this.ofBizClusterNodeStore.deleteNode(node) > 0) {
                this.clusterNodeAuditHandler.handleNodeRemoved(node, this.ofBizClusterNodeStore.getAllNodes());
            }
        }
        catch (DataAccessException ex) {
            throw new ClusterStateException(ex.getMessage());
        }
    }

    @Override
    public void moveToOffline(@NotNull String nodeId) throws ClusterStateException {
        Node node = this.node(nodeId);
        if (node != null) {
            if (node.getState() != Node.NodeState.ACTIVE) {
                throw new ClusterStateException("You can only change state of non alive and active node");
            }
        } else {
            throw new ClusterStateException("You can only change state of not null node");
        }
        this.updateNodeStateToOffline(node);
        log.info("{} Node {} is now in the OFFLINE state.", (Object)"[CLUSTER-STATE]", (Object)nodeId);
    }

    private void updateNodeStateToOffline(@NotNull Node node) throws ClusterStateException {
        try {
            Node nodeNew = this.ofBizClusterNodeStore.updateNode(node.getNodeId(), Node.NodeState.OFFLINE, node.getIp(), node.getCacheListenerPort(), node.getNodeBuildNumber(), node.getNodeVersion());
            this.clusterNodeAuditHandler.handleNodeDeactivated(nodeNew, node, this.ofBizClusterNodeStore.getAllNodes());
        }
        catch (DataAccessException ex) {
            throw new ClusterStateException(ex.getMessage());
        }
    }
}

