/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster;

import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.cluster.ClusterNodes;
import com.atlassian.jira.cluster.ClusterStateException;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.cluster.NodeStateManager;
import com.atlassian.jira.cluster.NodeStateService;
import com.atlassian.jira.cluster.NotClusteredException;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import java.util.Objects;

public class DefaultNodeStateService
implements NodeStateService {
    static final String FORBIDDEN_MESSAGE_CODE = "jira.admin.cluster.service.forbidden";
    private final ClusterNodes clusterNodes;
    private final GlobalPermissionManager globalPermissionManager;
    private final I18nHelper i18nHelper;
    private final NodeStateManager nodeStateManager;

    public DefaultNodeStateService(GlobalPermissionManager globalPermissionManager, I18nHelper i18nHelper, NodeStateManager nodeStateManager, ClusterNodes clusterNodes) {
        this.globalPermissionManager = Objects.requireNonNull(globalPermissionManager);
        this.i18nHelper = Objects.requireNonNull(i18nHelper);
        this.nodeStateManager = Objects.requireNonNull(nodeStateManager);
        this.clusterNodes = Objects.requireNonNull(clusterNodes);
    }

    public ServiceResult activate(ApplicationUser user) {
        return this.doPrivileged(user, NodeStateManager::activate);
    }

    public ServiceResult deactivate(ApplicationUser user) {
        return this.doPrivileged(user, NodeStateManager::deactivate);
    }

    public boolean isActive() {
        return this.clusterNodes.current().getState() == Node.NodeState.ACTIVE;
    }

    private ServiceResult doPrivileged(ApplicationUser user, NodeManagerCallback callback) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        try {
            if (this.hasManageNodePermission(user)) {
                callback.execute(this.nodeStateManager);
            } else {
                this.rejectAsForbidden((ErrorCollection)errorCollection);
            }
        }
        catch (NotClusteredException e) {
            errorCollection.addErrorMessage(e.getMessage(), ErrorCollection.Reason.FORBIDDEN);
        }
        catch (ClusterStateException e) {
            errorCollection.addErrorMessage(e.getMessage(), ErrorCollection.Reason.SERVER_ERROR);
        }
        return new ServiceResultImpl((ErrorCollection)errorCollection);
    }

    private boolean hasManageNodePermission(ApplicationUser user) {
        return this.globalPermissionManager.hasPermission(44, user);
    }

    private void rejectAsForbidden(ErrorCollection errorCollection) {
        String errorMessage = this.i18nHelper.getText(FORBIDDEN_MESSAGE_CODE);
        errorCollection.addErrorMessage(errorMessage, ErrorCollection.Reason.FORBIDDEN);
    }

    private static interface NodeManagerCallback {
        public void execute(NodeStateManager var1) throws ClusterStateException;
    }
}

