/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.cache.ehcache;

import com.atlassian.jira.cluster.cache.pauser.ReplicationPauserManager;
import com.atlassian.jira.cluster.distribution.localq.LocalQCacheManager;
import com.atlassian.jira.cluster.distribution.localq.LocalQCacheReplicator;
import com.atlassian.jira.cluster.distribution.localq.LocalQConfig;
import com.atlassian.jira.component.ComponentAccessor;
import java.util.Properties;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.CacheEventListenerFactory;
import net.sf.ehcache.util.PropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicatorFactory
extends CacheEventListenerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicatorFactory.class);
    private static final String REPLICATE_PUTS = "replicatePuts";
    private static final String REPLICATE_PUTS_VIA_COPY = "replicatePutsViaCopy";
    private static final String REPLICATE_UPDATES = "replicateUpdates";
    private static final String REPLICATE_UPDATES_VIA_COPY = "replicateUpdatesViaCopy";
    private static final String REPLICATE_REMOVALS = "replicateRemovals";

    public CacheEventListener createCacheEventListener(Properties properties) {
        boolean isLocalQReplicationDisabled = LocalQConfig.isLocalQReplicationDisabled();
        if (isLocalQReplicationDisabled) {
            LOG.warn("[Cache-replication] jira.cache.replication.localq.disabled=true is ignored since Jira 8.14.0.");
        }
        LOG.info("[Cache-replication] Cache replication using default cache replicator: {}", (Object)LocalQCacheReplicator.class.getSimpleName());
        return new LocalQCacheReplicator(this.extractBoolean(REPLICATE_PUTS, properties), this.extractBoolean(REPLICATE_PUTS_VIA_COPY, properties), this.extractBoolean(REPLICATE_UPDATES, properties), this.extractBoolean(REPLICATE_UPDATES_VIA_COPY, properties), this.extractBoolean(REPLICATE_REMOVALS, properties), ComponentAccessor.supplierOf(ReplicationPauserManager.class), ComponentAccessor.supplierOf(LocalQCacheManager.class));
    }

    private boolean extractBoolean(String key, Properties properties) {
        String property = PropertyUtil.extractAndLogProperty((String)key, (Properties)properties);
        return property == null || PropertyUtil.parseBoolean((String)property);
    }
}

