/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.cache.pauser;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.cluster.cache.pauser.ReplicationPauserManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class ClusteredReplicationPauserManager
implements ReplicationPauserManager {
    private static final Logger LOG = LoggerFactory.getLogger(ClusteredReplicationPauserManager.class);
    private static ThreadLocal<Boolean> pauseReplication = ThreadLocal.withInitial(() -> Boolean.FALSE);

    public ClusteredReplicationPauserManager() {
        LOG.debug("Clustered mode: {} implemented by {} ", (Object)ReplicationPauserManager.class.getSimpleName(), (Object)ClusteredReplicationPauserManager.class.getSimpleName());
    }

    @Override
    public boolean isReplicationPaused() {
        return pauseReplication.get();
    }

    @Override
    public void pauseReplicationFor(Runnable codeWillNotTriggerCacheReplication, String logContext) {
        try {
            this.start(logContext);
            codeWillNotTriggerCacheReplication.run();
        }
        finally {
            this.stop(logContext);
        }
    }

    public void start(String logContext) {
        LOG.debug("Disabling cache replication in thread: {}, context: {}", (Object)Thread.currentThread().getName(), (Object)logContext);
        pauseReplication.set(true);
    }

    public void stop(String logContext) {
        pauseReplication.set(false);
        LOG.debug("Re-enabling cache replication in thread: {}, context: {}", (Object)Thread.currentThread().getName(), (Object)logContext);
    }
}

