/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.dbr;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.cluster.dbr.DBRMessage;
import com.atlassian.jira.cluster.dbr.DBRMessageFactory;
import com.atlassian.jira.cluster.dbr.DBRMessageUpdateData;
import com.atlassian.jira.cluster.dbr.DBRMessageUpdateWithRelatedData;
import com.atlassian.jira.cluster.dbr.DBRSender;
import com.atlassian.jira.cluster.dbr.DBRSenderStats;
import com.atlassian.jira.cluster.dbr.DBRStatsListener;
import com.atlassian.jira.cluster.dbr.JiraDocumentUtil;
import com.atlassian.jira.cluster.dbr.transport.DBRTransportManager;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.index.DefaultIssueIndexer;
import com.atlassian.jira.issue.index.IndexDirectoryFactory;
import com.google.common.base.Stopwatch;
import com.google.gson.Gson;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.document.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDBRSender
implements DBRSender {
    private static final Logger log = LoggerFactory.getLogger(DefaultDBRSender.class);
    static final int DISABLED_FREQUENCY_LOGGER = 1000;
    private final AtomicLong disabledCounter = new AtomicLong();
    private final DBRMessageFactory documentMessageFactory;
    private final DBRSenderStats.TotalAndSnapshotDBRSenderStats stats;
    private final DBRTransportManager dbrTransportManager;
    private final FeatureManager featureManager;

    public DefaultDBRSender(DBRMessageFactory documentMessageFactory, FeatureManager featureManager, DBRTransportManager dbrTransportManager) {
        this.documentMessageFactory = documentMessageFactory;
        this.stats = new DBRSenderStats.TotalAndSnapshotDBRSenderStats(new DBRStatsListener());
        this.featureManager = featureManager;
        this.dbrTransportManager = dbrTransportManager;
    }

    private boolean isDisabled() {
        return !this.featureManager.isEnabled(JiraFeatureFlagRegistrar.DOCUMENT_BASED_INDEX_REPLICATION);
    }

    private boolean handleDisabled() {
        if (this.isDisabled()) {
            long currentThreadDisabledCounter = this.disabledCounter.incrementAndGet();
            if (currentThreadDisabledCounter == 1L || currentThreadDisabledCounter % 1000L == 0L) {
                log.info("[DBR] [SENDER] DBR is not enabled or is disabled by the feature flag: '{}'. {} dbr replications not processed.", (Object)JiraFeatureFlagRegistrar.DOCUMENT_BASED_INDEX_REPLICATION.featureKey(), (Object)currentThreadDisabledCounter);
            }
            return true;
        }
        this.disabledCounter.set(0L);
        return false;
    }

    @Override
    public void sendUpdateWithRelated(DefaultIssueIndexer.Documents documents, long cost) {
        if (this.handleDisabled()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("[DBR] [SENDER] Sending an update issue with related with documents: {}", (Object)JiraDocumentUtil.documentsToShortString(documents));
        }
        try {
            Stopwatch stopwatch = Stopwatch.createStarted();
            DBRMessage<DBRMessageUpdateWithRelatedData> dbrMessage = this.documentMessageFactory.createUpdateWithRelated(documents, cost);
            long duration = stopwatch.stop().elapsed(TimeUnit.MILLISECONDS);
            log.debug("[DBR] [SENDER] Created a dbr update with related message: {} in: {} millis", dbrMessage, (Object)duration);
            this.stats.onCreateDBRMessageUpdateWithRelated(documents, duration, dbrMessage.messageSize());
            this.sendDBRMessage(dbrMessage);
        }
        catch (Exception t) {
            log.error("[DBR] [SENDER] Error when creating a dbr update with related message for documents: {}. You can disable this functionality with the feature flag: '{}'. Error: {}", new Object[]{JiraDocumentUtil.documentsToShortString(documents), JiraFeatureFlagRegistrar.DOCUMENT_BASED_INDEX_REPLICATION.featureKey(), t.getMessage(), t});
            this.stats.onCreateDBRMessageUpdateWithRelatedError(t);
        }
    }

    @Override
    public void sendUpdate(IndexDirectoryFactory.Name index, Document document, long cost) {
        if (this.handleDisabled()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("[DBR] [SENDER] Sending an update with document: {} to index: {}", (Object)JiraDocumentUtil.documentToShortString(index, document), (Object)index);
        }
        try {
            Stopwatch stopwatch = Stopwatch.createStarted();
            DBRMessage<DBRMessageUpdateData> dbrMessage = this.documentMessageFactory.createUpdate(index, document, cost);
            long duration = stopwatch.stop().elapsed(TimeUnit.MILLISECONDS);
            log.debug("[DBR] [SENDER] Created a dbr update message: {} in: {} millis", dbrMessage, (Object)duration);
            this.stats.onCreateDBRMessageUpdate(index, duration, dbrMessage.messageSize());
            this.sendDBRMessage(dbrMessage);
        }
        catch (Exception t) {
            log.error("[DBR] [SENDER] Error when creating a dbr update message for index: {}, document: {}. You can disable this functionality with the feature flag: '{}'. Error: {}", new Object[]{index, JiraDocumentUtil.documentToShortString(index, document), JiraFeatureFlagRegistrar.DOCUMENT_BASED_INDEX_REPLICATION.featureKey(), t.getMessage(), t});
            this.stats.onCreateDBRMessageUpdateError(t);
        }
    }

    private void sendDBRMessage(DBRMessage dbrMessage) {
        try {
            this.dbrTransportManager.send(dbrMessage);
            log.debug("[DBR] [SENDER] Sent a dbr message: {}", (Object)dbrMessage);
            this.stats.onSendDBRMessage(dbrMessage);
        }
        catch (Exception t) {
            log.error("[DBR] [SENDER] Error when sending a dbr message: {}", (Object)dbrMessage, (Object)t);
            this.stats.onSendDBRMessageError(t);
        }
    }

    DBRSenderStats.MutableDBRSenderStats.Result total() {
        return this.stats.total();
    }

    @Override
    public Map totalStats() {
        Gson gson = new Gson();
        return (Map)gson.fromJson(this.stats.total().toString(), Map.class);
    }

    DBRSenderStats.MutableDBRSenderStats.Result snapshot(boolean reset) {
        return this.stats.snapshot(reset);
    }
}

