/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.distribution.localq.rmi.auth;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicBoolean;

public class AuthenticatingSocketWrapper
extends Socket {
    private final AtomicBoolean authenticationDone = new AtomicBoolean(false);
    private final Object authenticationDoneLock = new Object();
    private final Socket backingSocket;
    private final ThrowingConsumer<Socket, IOException> authenticator;

    public AuthenticatingSocketWrapper(Socket backingSocket, ThrowingConsumer<Socket, IOException> authenticator) {
        this.backingSocket = backingSocket;
        this.authenticator = authenticator;
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void bind(SocketAddress bindpoint) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public InetAddress getInetAddress() {
        return this.backingSocket.getInetAddress();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.backingSocket.getLocalAddress();
    }

    @Override
    public int getPort() {
        return this.backingSocket.getPort();
    }

    @Override
    public int getLocalPort() {
        return this.backingSocket.getLocalPort();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.backingSocket.getRemoteSocketAddress();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.backingSocket.getLocalSocketAddress();
    }

    @Override
    public SocketChannel getChannel() {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new AuthenticatingInputStream(this.backingSocket.getInputStream());
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return new AuthenticatingOutputStream(this.backingSocket.getOutputStream());
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        this.backingSocket.setTcpNoDelay(on);
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return this.backingSocket.getTcpNoDelay();
    }

    @Override
    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.backingSocket.setSoLinger(on, linger);
    }

    @Override
    public int getSoLinger() throws SocketException {
        return this.backingSocket.getSoLinger();
    }

    @Override
    public void sendUrgentData(int data) throws IOException {
        this.assureAuthenticated();
        this.backingSocket.sendUrgentData(data);
    }

    @Override
    public void setOOBInline(boolean on) throws SocketException {
        this.backingSocket.setOOBInline(on);
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        return this.backingSocket.getOOBInline();
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        this.backingSocket.setSoTimeout(timeout);
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.backingSocket.getSoTimeout();
    }

    @Override
    public void setSendBufferSize(int size) throws SocketException {
        this.backingSocket.setReceiveBufferSize(size);
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        return this.backingSocket.getSendBufferSize();
    }

    @Override
    public void setReceiveBufferSize(int size) throws SocketException {
        this.backingSocket.setReceiveBufferSize(size);
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        return this.backingSocket.getReceiveBufferSize();
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
        this.backingSocket.setKeepAlive(on);
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return this.backingSocket.getKeepAlive();
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
        this.backingSocket.setTrafficClass(tc);
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return this.backingSocket.getTrafficClass();
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        this.backingSocket.setReuseAddress(on);
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.backingSocket.getReuseAddress();
    }

    @Override
    public void close() throws IOException {
        this.assureAuthenticated();
        this.backingSocket.close();
    }

    @Override
    public void shutdownInput() throws IOException {
        this.assureAuthenticated();
        this.backingSocket.shutdownInput();
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.assureAuthenticated();
        this.backingSocket.shutdownOutput();
    }

    @Override
    public String toString() {
        return this.backingSocket.toString();
    }

    @Override
    public boolean isConnected() {
        return this.backingSocket.isConnected();
    }

    @Override
    public boolean isBound() {
        return this.backingSocket.isBound();
    }

    @Override
    public boolean isClosed() {
        return this.backingSocket.isClosed();
    }

    @Override
    public boolean isInputShutdown() {
        return this.backingSocket.isInputShutdown();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.backingSocket.isOutputShutdown();
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        this.backingSocket.setPerformancePreferences(connectionTime, latency, bandwidth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assureAuthenticated() throws IOException {
        if (!this.authenticationDone.get()) {
            Object object = this.authenticationDoneLock;
            synchronized (object) {
                if (!this.authenticationDone.get()) {
                    this.authenticator.accept(this.backingSocket);
                    this.authenticationDone.set(true);
                }
            }
        }
    }

    private class AuthenticatingInputStream
    extends InputStream {
        private final InputStream inputStream;

        public AuthenticatingInputStream(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public int read() throws IOException {
            AuthenticatingSocketWrapper.this.assureAuthenticated();
            return this.inputStream.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            AuthenticatingSocketWrapper.this.assureAuthenticated();
            return this.inputStream.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            AuthenticatingSocketWrapper.this.assureAuthenticated();
            return this.inputStream.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            AuthenticatingSocketWrapper.this.assureAuthenticated();
            return this.inputStream.skip(n);
        }

        @Override
        public int available() throws IOException {
            AuthenticatingSocketWrapper.this.assureAuthenticated();
            return this.inputStream.available();
        }

        @Override
        public void close() throws IOException {
            AuthenticatingSocketWrapper.this.assureAuthenticated();
            this.inputStream.close();
        }

        @Override
        public void mark(int readlimit) {
            try {
                AuthenticatingSocketWrapper.this.assureAuthenticated();
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
            this.inputStream.mark(readlimit);
        }

        @Override
        public void reset() throws IOException {
            this.inputStream.reset();
        }

        @Override
        public boolean markSupported() {
            return this.inputStream.markSupported();
        }
    }

    private class AuthenticatingOutputStream
    extends OutputStream {
        private final OutputStream outputStream;

        public AuthenticatingOutputStream(OutputStream outputStream) {
            this.outputStream = outputStream;
        }

        @Override
        public void write(int b) throws IOException {
            AuthenticatingSocketWrapper.this.assureAuthenticated();
            this.outputStream.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            AuthenticatingSocketWrapper.this.assureAuthenticated();
            this.outputStream.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            AuthenticatingSocketWrapper.this.assureAuthenticated();
            this.outputStream.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.outputStream.flush();
        }

        @Override
        public void close() throws IOException {
            AuthenticatingSocketWrapper.this.assureAuthenticated();
            this.outputStream.close();
        }
    }

    public static interface ThrowingConsumer<T, E extends Exception> {
        public void accept(T var1) throws E;
    }
}

