/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.health;

import com.atlassian.jira.cluster.ClusterNodeProperties;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.health.HealthCheck;
import com.atlassian.jira.health.HealthCheckResult;
import com.atlassian.jira.health.HealthCheckTemplate;
import com.atlassian.jira.health.LifecyclePhase;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.johnson.JohnsonEventType;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevels;
import com.google.common.collect.ImmutableSet;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;

@ParametersAreNonnullByDefault
public class NodeIdHealthCheck
extends HealthCheckTemplate {
    private static final String CAUSE = "node-id-not-configured";
    private static final String FAILURE_MESSAGE = "JIRA is configured with a cluster.properties file, but the node ID is not set.";
    private static final URL KB_URL = UrlBuilder.createURL((String)"https://confluence.atlassian.com/x/N4JiJ");
    @Nullable
    private final ClusterNodeProperties clusterNodeProperties;

    public static NodeIdHealthCheck getInstance(HealthCheck ... prerequisites) {
        return new NodeIdHealthCheck((ClusterNodeProperties)ComponentAccessor.getComponent(ClusterNodeProperties.class), prerequisites);
    }

    NodeIdHealthCheck(@Nullable ClusterNodeProperties clusterNodeProperties, HealthCheck ... prerequisites) {
        super(Arrays.asList(prerequisites));
        this.clusterNodeProperties = clusterNodeProperties;
    }

    @Override
    protected Set<LifecyclePhase> getApplicablePhases() {
        return ImmutableSet.of((Object)((Object)LifecyclePhase.PLUGINS_STARTUP_FINISHED));
    }

    @Override
    protected List<HealthCheckResult> doPerform() {
        return this.getNodeId().filter(StringUtils::isBlank).map(nodeId -> this.fatalBlankNodeIdResult()).orElseGet(Collections::emptyList);
    }

    private Optional<String> getNodeId() {
        return Optional.ofNullable(this.clusterNodeProperties).filter(ClusterNodeProperties::propertyFileExists).map(ClusterNodeProperties::getNodeId);
    }

    private List<HealthCheckResult> fatalBlankNodeIdResult() {
        return HealthCheckResult.fail(this, new Event(JohnsonEventType.CLUSTERING.eventType(), "JIRA Cluster Node ID", FAILURE_MESSAGE, EventLevels.fatal()), KB_URL, CAUSE, FAILURE_MESSAGE);
    }
}

