/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.component.pico.adapter;

import com.atlassian.jira.component.pico.adapter.AbstractComponentAdaptor;
import com.atlassian.jira.config.component.InvocationSwitcher;
import com.atlassian.jira.config.component.SwitchingInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;

public abstract class AbstractSwitchingInvocationAdaptor<T>
extends AbstractComponentAdaptor<T> {
    private final Class<? extends T> enabledClass;
    private final Class<? extends T> disabledClass;

    protected AbstractSwitchingInvocationAdaptor(Class<T> interfaceClass, Class<? extends T> enabledClass, Class<? extends T> disabledClass) {
        super(interfaceClass);
        this.enabledClass = Objects.requireNonNull(enabledClass);
        this.disabledClass = Objects.requireNonNull(disabledClass);
    }

    public final Class<? extends T> getComponentImplementation() {
        return this.interfaceClass;
    }

    public final T getComponentInstance(PicoContainer container) throws PicoCompositionException {
        return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{this.interfaceClass}, this.getHandler(container));
    }

    private InvocationHandler getHandler(PicoContainer container) {
        Object enabled = container.getComponent(this.enabledClass);
        Object disabled = container.getComponent(this.disabledClass);
        return new SwitchingInvocationHandler<Object>(enabled, disabled, this.getInvocationSwitcher());
    }

    @Nonnull
    protected abstract InvocationSwitcher getInvocationSwitcher();
}

