/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.config.IssueTypeSchemeService;
import com.atlassian.jira.config.IssueTypeService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.query.Query;
import com.atlassian.query.order.SortOrder;
import io.atlassian.fugue.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DefaultIssueTypeSchemeService
implements IssueTypeSchemeService {
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final ProjectService projectService;
    private final SearchService searchService;
    private final GlobalPermissionManager globalPermissionManager;
    private final IssueTypeService issueTypeService;

    public DefaultIssueTypeSchemeService(SearchService searchService, IssueTypeSchemeManager issueTypeSchemeManager, ProjectService projectService, GlobalPermissionManager globalPermissionManager, I18nHelper.BeanFactory i18nFactory, IssueTypeService issueTypeService) {
        this.searchService = searchService;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.projectService = projectService;
        this.globalPermissionManager = globalPermissionManager;
        this.issueTypeService = issueTypeService;
    }

    public ServiceOutcome<FieldConfigScheme> createIssueTypeScheme(ApplicationUser user, String name, String description, List<String> issueTypeIds, String defaultIssueTypeId) {
        try {
            return ServiceOutcomeImpl.ok(this.createScheme(user, name, description, issueTypeIds, defaultIssueTypeId));
        }
        catch (ITSException e) {
            return ServiceOutcomeImpl.from(e.errCollection);
        }
    }

    public ServiceOutcome<List<FieldConfigScheme>> getAllIssueTypeSchemes(ApplicationUser user) {
        try {
            return ServiceOutcomeImpl.ok(this.getAllSchemes(user));
        }
        catch (ITSException e) {
            return ServiceOutcomeImpl.from(e.errCollection);
        }
    }

    public ServiceOutcome<FieldConfigScheme> getIssueTypeScheme(ApplicationUser user, long schemeId) {
        try {
            return ServiceOutcomeImpl.ok(this.getScheme(user, schemeId));
        }
        catch (ITSException e) {
            return ServiceOutcomeImpl.from(e.errCollection);
        }
    }

    public ServiceOutcome<FieldConfigScheme> updateIssueTypeScheme(ApplicationUser user, long schemeId, String name, String description, List<String> issueTypeIds, String defaultIssueTypeId) {
        try {
            return ServiceOutcomeImpl.ok(this.updateScheme(user, schemeId, name, description, issueTypeIds, defaultIssueTypeId));
        }
        catch (ITSException e) {
            return ServiceOutcomeImpl.from(e.errCollection);
        }
    }

    public ServiceOutcome<Void> deleteIssueTypeScheme(ApplicationUser user, long schemeId) {
        try {
            this.deleteScheme(user, schemeId);
            return ServiceOutcomeImpl.ok(null);
        }
        catch (ITSException e) {
            return ServiceOutcomeImpl.from(e.errCollection);
        }
    }

    public ServiceOutcome<Void> addProjectAssociations(ApplicationUser user, long schemeId, List<String> projectIdsOrKeys) {
        try {
            this.addAssociations(user, schemeId, projectIdsOrKeys);
            return ServiceOutcomeImpl.ok(null);
        }
        catch (ITSException e) {
            return ServiceOutcomeImpl.from(e.errCollection);
        }
    }

    private void addAssociations(ApplicationUser user, long schemeId, List<String> projectIdsOrKeys) throws ITSException {
        this.verifyAdmin(user);
        List<Project> newProjects = this.projectsFromKeyOrId(user, projectIdsOrKeys, true);
        FieldConfigScheme scheme = this.getScheme(user, schemeId);
        List<Issue> needMigration = this.issuesRequiringMigrationsDueToSchemeAssociation(user, scheme, newProjects.stream().map(Project::getId).collect(Collectors.toList()));
        if (!needMigration.isEmpty()) {
            throw new ITSException("Cannot add associations because an IssueType migration would be required.", ErrorCollection.Reason.VALIDATION_FAILED);
        }
        this.issueTypeSchemeManager.addProjectAssociations(scheme, newProjects);
    }

    public ServiceOutcome<List<Project>> getAssociatedProjects(ApplicationUser user, long schemeId) {
        try {
            return ServiceOutcomeImpl.ok(this.getAssociations(user, schemeId));
        }
        catch (ITSException e) {
            return ServiceOutcomeImpl.from(e.errCollection);
        }
    }

    public ServiceOutcome<Void> setProjectAssociations(ApplicationUser user, long schemeId, List<String> projectIdsOrKeys) {
        try {
            this.associateProjects(user, schemeId, projectIdsOrKeys, true);
            return ServiceOutcomeImpl.ok(null);
        }
        catch (ITSException e) {
            return ServiceOutcomeImpl.from(e.errCollection);
        }
    }

    public ServiceOutcome<Void> removeProjectAssociation(ApplicationUser user, long schemeId, String projKeyOrId) {
        try {
            this.removeOneAssociation(user, schemeId, projKeyOrId);
            return ServiceOutcomeImpl.ok(null);
        }
        catch (ITSException e) {
            return ServiceOutcomeImpl.from(e.errCollection);
        }
    }

    public ServiceOutcome<Void> removeAllProjectAssociations(ApplicationUser user, long schemeId) {
        try {
            this.removeAllAssociations(user, schemeId);
            return ServiceOutcomeImpl.ok(null);
        }
        catch (ITSException e) {
            return ServiceOutcomeImpl.from(e.errCollection);
        }
    }

    public long getNumIssuesMatchingTypesInProjects(ApplicationUser user, Collection<Long> projectIds, Collection<String> issueTypeIds) throws SearchException {
        Query query = this.issuesMatchingTypesInProjectsQuery(projectIds, issueTypeIds);
        return this.searchService.searchCount(user, query);
    }

    public List<Issue> getIssuesMatchingTypesInProjects(ApplicationUser user, Collection<Long> projectIds, Collection<String> issueTypeIds) throws SearchException {
        Query query = this.issuesMatchingTypesInProjectsQuery(projectIds, issueTypeIds);
        SearchResults searchResults = this.searchService.search(user, query, PagerFilter.getUnlimitedFilter());
        return searchResults.getResults();
    }

    public ServiceOutcome<List<Issue>> getIssuesRequiringMigration(ApplicationUser user, Collection<String> chosenIssueTypeIds, List<Long> projectIds) {
        try {
            return ServiceOutcomeImpl.ok(this.issuesRequiringMigration(user, chosenIssueTypeIds, projectIds));
        }
        catch (ITSException e) {
            return ServiceOutcomeImpl.from(e.errCollection);
        }
    }

    public ServiceOutcome<List<Issue>> getIssuesRequiringMigrationDueToSchemeAssociation(ApplicationUser user, FieldConfigScheme issueTypeScheme, List<Long> projectIds) {
        try {
            return ServiceOutcomeImpl.ok(this.issuesRequiringMigrationsDueToSchemeAssociation(user, issueTypeScheme, projectIds));
        }
        catch (ITSException e) {
            return ServiceOutcomeImpl.from(e.errCollection);
        }
    }

    public <T> ServiceOutcome<T> errorCase(String msg, ErrorCollection.Reason reason) {
        return ServiceOutcomeImpl.error(msg, reason);
    }

    public IssueType getDefaultIssueType(FieldConfigScheme issueTypeScheme) {
        return this.issueTypeSchemeManager.getDefaultValue(issueTypeScheme.getOneAndOnlyConfig());
    }

    private FieldConfigScheme createScheme(ApplicationUser user, String name, String description, List<String> issueTypeIds, String defaultIssueTypeId) throws ITSException {
        this.verifyAdmin(user);
        this.verifyNonEmptyName(name);
        this.verifyNameDoesntExist(name, user);
        this.verifyIssueTypesAndDefaultIssueType(issueTypeIds, defaultIssueTypeId, user);
        FieldConfigScheme itScheme = this.issueTypeSchemeManager.create(name, description, issueTypeIds);
        if (defaultIssueTypeId != null) {
            this.issueTypeSchemeManager.setDefaultValue(itScheme.getOneAndOnlyConfig(), defaultIssueTypeId.toString());
        }
        return itScheme;
    }

    private List<FieldConfigScheme> getAllSchemes(ApplicationUser user) throws ITSException {
        this.verifyAdmin(user);
        return this.issueTypeSchemeManager.getAllSchemes();
    }

    private FieldConfigScheme getScheme(ApplicationUser user, long schemeId) throws ITSException {
        this.verifyAdmin(user);
        Optional<FieldConfigScheme> maybeScheme = this.issueTypeSchemeManager.getAllSchemes().stream().filter(sch -> sch.getId() == schemeId).findFirst();
        if (!maybeScheme.isPresent()) {
            throw new ITSException("Could not find Issue Type Scheme with id " + schemeId, ErrorCollection.Reason.NOT_FOUND);
        }
        return maybeScheme.get();
    }

    private FieldConfigScheme updateScheme(ApplicationUser user, long schemeId, String name, String description, List<String> issueTypeIds, String defaultIssueTypeId) throws ITSException {
        this.verifyAdmin(user);
        this.verifyNonEmptyName(name);
        this.verifyNoOtherSchemesHaveName(name, schemeId, user);
        this.verifyIssueTypesAndDefaultIssueType(issueTypeIds, defaultIssueTypeId, user);
        FieldConfigScheme scheme = this.getScheme(user, schemeId);
        List<Issue> issuesThatNeedMigration = this.issuesRequiringMigration(user, issueTypeIds, scheme.getAssociatedProjectIds());
        if (!issuesThatNeedMigration.isEmpty()) {
            throw new ITSException("Cannot update IssueTypeScheme because an IssueType migration would be required.", ErrorCollection.Reason.VALIDATION_FAILED);
        }
        FieldConfigScheme updated = this.issueTypeSchemeManager.update(new FieldConfigScheme.Builder(scheme).setName(name).setDescription(description).toFieldConfigScheme(), new ArrayList<String>(issueTypeIds));
        this.issueTypeSchemeManager.setDefaultValue(scheme.getOneAndOnlyConfig(), defaultIssueTypeId);
        return updated;
    }

    private void deleteScheme(ApplicationUser user, long schemeId) throws ITSException {
        this.verifyAdmin(user);
        if (schemeId == this.issueTypeSchemeManager.getDefaultIssueTypeSchemeId()) {
            throw new ITSException("Cannot delete the default IssueTypeScheme.", ErrorCollection.Reason.FORBIDDEN);
        }
        FieldConfigScheme scheme = this.getScheme(user, schemeId);
        this.issueTypeSchemeManager.deleteScheme(scheme);
    }

    private List<Project> getAssociations(ApplicationUser user, long schemeId) throws ITSException {
        this.verifyAdmin(user);
        FieldConfigScheme scheme = this.getScheme(user, schemeId);
        return new ArrayList<Project>(scheme.getAssociatedProjectObjects());
    }

    private void associateProjects(ApplicationUser user, long schemeId, List<String> projectIdsOrKeys, boolean overwriteExisting) throws ITSException {
        this.verifyAdmin(user);
        List<Project> newProjects = this.projectsFromKeyOrId(user, projectIdsOrKeys, true);
        FieldConfigScheme scheme = this.getScheme(user, schemeId);
        List<Issue> needMigration = this.issuesRequiringMigrationsDueToSchemeAssociation(user, scheme, newProjects.stream().map(p -> p.getId()).collect(Collectors.toList()));
        if (!needMigration.isEmpty()) {
            throw new ITSException("Cannot perform associations because an IssueType migration would be required.", ErrorCollection.Reason.VALIDATION_FAILED);
        }
        ArrayList<Project> newAssociations = new ArrayList<Project>(newProjects);
        if (!overwriteExisting) {
            newAssociations.addAll(scheme.getAssociatedProjectObjects());
        }
        this.issueTypeSchemeManager.setProjectAssociationsForIssueTypeScheme(scheme, newAssociations);
    }

    private void removeOneAssociation(ApplicationUser user, long schemeId, String projKeyOrId) throws ITSException {
        this.verifyAdmin(user);
        FieldConfigScheme scheme = this.getScheme(user, schemeId);
        List<Project> associatedProjects = this.getAssociations(user, schemeId);
        Project projToRemove = this.projFromKeyOrId(user, projKeyOrId, false);
        if (schemeId == this.issueTypeSchemeManager.getDefaultIssueTypeSchemeId()) {
            throw new ITSException("Cannot remove associations for the default IssueTypeScheme", ErrorCollection.Reason.FORBIDDEN);
        }
        if (!associatedProjects.contains(projToRemove)) {
            throw new ITSException("Project " + projToRemove.getKey() + " (id=" + projToRemove.getId() + ") is not associated with scheme " + schemeId, ErrorCollection.Reason.NOT_FOUND);
        }
        this.issueTypeSchemeManager.removeProjectAssociations(scheme, Collections.singleton(projToRemove));
    }

    private void removeAllAssociations(ApplicationUser user, long schemeId) throws ITSException {
        this.verifyAdmin(user);
        if (schemeId == this.issueTypeSchemeManager.getDefaultIssueTypeSchemeId()) {
            throw new ITSException("Cannot remove associations for the default IssueTypeScheme", ErrorCollection.Reason.FORBIDDEN);
        }
        FieldConfigScheme scheme = this.getScheme(user, schemeId);
        List<Project> currentlyAssociatedProjects = this.getAssociations(user, schemeId);
        this.issueTypeSchemeManager.removeProjectAssociations(scheme, currentlyAssociatedProjects);
    }

    private List<Issue> issuesRequiringMigration(ApplicationUser user, Collection<String> chosenIssueTypeIds, List<Long> projectIds) throws ITSException {
        Collection issueTypesForProjects = projectIds.stream().map(id -> this.projectService.getProjectById(id)).filter(res -> res.isValid()).flatMap(res -> this.issueTypeSchemeManager.getIssueTypesForProject(res.get()).stream()).collect(Collectors.toList());
        Collection missingIssueTypes = issueTypesForProjects.stream().map(itype -> itype.getId()).filter(id -> !chosenIssueTypeIds.contains(id)).collect(Collectors.toSet());
        try {
            return missingIssueTypes.isEmpty() ? Collections.emptyList() : this.getIssuesMatchingTypesInProjects(user, projectIds, missingIssueTypes);
        }
        catch (SearchException e) {
            throw new ITSException("Problems searching for IssueTypes that would require a migration.", ErrorCollection.Reason.SERVER_ERROR);
        }
    }

    private List<Issue> issuesRequiringMigrationsDueToSchemeAssociation(ApplicationUser user, FieldConfigScheme issueTypeScheme, List<Long> projectIds) throws ITSException {
        List<String> issueTypesForScheme = this.issueTypeSchemeManager.getIssueTypesForScheme(issueTypeScheme).stream().map(o -> o.getId()).collect(Collectors.toList());
        return this.issuesRequiringMigration(user, issueTypesForScheme, projectIds);
    }

    private void verifyIssueTypesAndDefaultIssueType(List<String> issueTypeIds, String defaultIssueTypeId, ApplicationUser user) throws ITSException {
        if (issueTypeIds == null || issueTypeIds.isEmpty()) {
            throw new ITSException("An IssueTypeScheme must have at least one associated IssueType", ErrorCollection.Reason.VALIDATION_FAILED);
        }
        boolean validIssueTypes = issueTypeIds.stream().allMatch(id -> this.issueTypeService.getIssueType(user, id.toString()).isDefined());
        if (!validIssueTypes) {
            String typeIds = String.join((CharSequence)", ", issueTypeIds);
            throw new ITSException("An IssueTypeScheme have valid IssueTypes. Chosen issue type ids: " + typeIds, ErrorCollection.Reason.VALIDATION_FAILED);
        }
        if (defaultIssueTypeId != null && !issueTypeIds.contains(defaultIssueTypeId)) {
            throw new ITSException("An IssueTypeScheme's default IssueType must be one of its associated IssueTypes. Invalid default: " + defaultIssueTypeId, ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    private void verifyNameDoesntExist(String name, ApplicationUser user) throws ITSException {
        List<FieldConfigScheme> schemes = this.getAllSchemes(user);
        boolean nameAlreadyExists = schemes.stream().anyMatch(sch -> name.equals(sch.getName()));
        if (nameAlreadyExists) {
            throw new ITSException("IssueTypeScheme names must be unique.", ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    private void verifyNonEmptyName(String name) throws ITSException {
        if (name == null || name.isEmpty()) {
            throw new ITSException("IssueTypeScheme names must be non-null and non-empty", ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    private void verifyNoOtherSchemesHaveName(String name, long currSchemeId, ApplicationUser user) throws ITSException {
        List<FieldConfigScheme> schemes = this.getAllSchemes(user);
        boolean nameAlreadyExists = schemes.stream().anyMatch(sch -> name.equals(sch.getName()) && !sch.getId().equals(currSchemeId));
        if (nameAlreadyExists) {
            throw new ITSException("IssueTypeScheme names must be unique.", ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    private Query issuesMatchingTypesInProjectsQuery(Collection<Long> projectIds, Collection<String> issueTypeIds) {
        JqlQueryBuilder builder = JqlQueryBuilder.newBuilder();
        JqlClauseBuilder whereBuilder = builder.where().defaultAnd();
        if (issueTypeIds != null && !issueTypeIds.isEmpty()) {
            whereBuilder.issueType().inStrings(issueTypeIds);
        }
        if (projectIds != null && !projectIds.isEmpty()) {
            whereBuilder.project().inNumbers(projectIds);
        }
        builder.orderBy().project(SortOrder.ASC).issueType(SortOrder.ASC);
        return builder.buildQuery();
    }

    private Either<Long, String> parseKeyOrIdFromString(String projectKeyOrId) {
        return StringUtils.isNumeric((CharSequence)projectKeyOrId) ? Either.left((Object)Long.parseLong(projectKeyOrId)) : Either.right((Object)projectKeyOrId);
    }

    private Project projFromKeyOrId(ApplicationUser user, String projectKeyOrId, boolean validationContext) throws ITSException {
        ProjectService.GetProjectResult result = (ProjectService.GetProjectResult)this.parseKeyOrIdFromString(projectKeyOrId).fold(id -> this.projectService.getProjectById(user, id), key -> this.projectService.getProjectByKey(user, key));
        if (result.isValid()) {
            return result.get();
        }
        if (validationContext) {
            String origErrors = result.getErrorCollection().getErrorMessages().stream().reduce("", (a, b) -> a + ";  " + b);
            throw new ITSException("Errors while validating: " + origErrors, ErrorCollection.Reason.VALIDATION_FAILED);
        }
        throw new ITSException(result.getErrorCollection());
    }

    private List<Project> projectsFromKeyOrId(ApplicationUser user, Collection<String> keysOrIds, boolean validationContext) throws ITSException {
        if (keysOrIds == null) {
            return Collections.emptyList();
        }
        ArrayList<Project> projects = new ArrayList<Project>();
        for (String keyOrId : keysOrIds) {
            projects.add(this.projFromKeyOrId(user, keyOrId, validationContext));
        }
        return projects;
    }

    private void verifyAdmin(ApplicationUser user) throws ITSException {
        if (!this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user)) {
            throw new ITSException("User must be a Jira admin to perform this function", ErrorCollection.Reason.FORBIDDEN);
        }
    }

    private class ITSException
    extends Exception {
        final ErrorCollection errCollection;

        public ITSException(String message, ErrorCollection.Reason reason) {
            this.errCollection = new SimpleErrorCollection(message, reason);
        }

        public ITSException(ErrorCollection errors) {
            this.errCollection = errors;
        }
    }
}

