/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.database;

import com.atlassian.config.bootstrap.AtlassianBootstrapManager;
import com.atlassian.config.bootstrap.BootstrapException;
import com.atlassian.jira.config.database.Datasource;
import com.atlassian.jira.util.dbc.Assertions;
import java.sql.Connection;
import org.dom4j.Element;
import org.ofbiz.core.entity.config.DatasourceInfo;
import org.ofbiz.core.entity.config.JndiDatasourceInfo;

public final class JndiDatasource
implements Datasource {
    static final String JNDI_DATASOURCE = "jndi-datasource";
    static final String JNDI_NAME = "jndi-name";
    private final String jndiName;

    public JndiDatasource(String jndiName) {
        this.jndiName = Assertions.notBlank((String)"JNDI name", (String)jndiName);
    }

    public JndiDatasource(JndiDatasourceInfo jndi) {
        this(((JndiDatasourceInfo)Assertions.notNull((String)"JNDI info", (Object)jndi)).getJndiName());
    }

    public String getJndiName() {
        return this.jndiName;
    }

    @Override
    public Connection getConnection(AtlassianBootstrapManager bootstrapManager) throws BootstrapException {
        return bootstrapManager.getTestDatasourceConnection(this.jndiName);
    }

    @Override
    public DatasourceInfo getDatasource(String datasourceName, String fieldType, String schemaName) {
        JndiDatasourceInfo jndiInfo = new JndiDatasourceInfo(this.jndiName, "default");
        return new DatasourceInfo(datasourceName, fieldType, schemaName, jndiInfo);
    }

    @Override
    public String getDescriptorValue(String databaseType) {
        return databaseType + " " + this.jndiName;
    }

    @Override
    public String getDescriptorLabel() {
        return "Database JNDI config";
    }

    static JndiDatasource parse(Element datasourceElement) {
        String jndiName = datasourceElement.elementText(JNDI_NAME);
        return new JndiDatasource(jndiName);
    }

    void writeTo(Element element) {
        Element jndi = element.addElement(JNDI_DATASOURCE);
        jndi.addElement(JNDI_NAME).setText(this.getJndiName());
    }
}

