/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.database.jdbcurlparser;

import com.atlassian.jira.config.database.jdbcurlparser.AbstractJdbcUrlParser;
import com.atlassian.jira.config.database.jdbcurlparser.DatabaseInstance;
import com.atlassian.jira.exception.ParseException;
import com.google.common.base.Splitter;

public class SqlServerMicrosoftDriverUrlParser
extends AbstractJdbcUrlParser {
    private static final String MICROSOFT_DRIVER_PREFIX = "jdbc:sqlserver://";
    private static final char SEPARATOR = ';';
    private static final String SERVER_PROPERTY = "serverName=";
    private static final String PORT_PROPERTY = "portNumber=";
    private static final String DATABASE_PROPERTY = "databaseName=";

    @Override
    public String getUrl(String hostname, String port, String instance) {
        String serverName = hostname.trim();
        String portNumber = port.trim();
        String databaseName = instance.trim();
        StringBuilder jdbcUrl = new StringBuilder(MICROSOFT_DRIVER_PREFIX);
        jdbcUrl.append(';').append(SERVER_PROPERTY).append(serverName);
        if (portNumber.length() > 0) {
            jdbcUrl.append(';').append(PORT_PROPERTY).append(portNumber);
        }
        if (databaseName.length() > 0) {
            jdbcUrl.append(';').append(DATABASE_PROPERTY).append(databaseName);
        }
        return jdbcUrl.toString();
    }

    @Override
    public DatabaseInstance parseUrl(String jdbcUrl) throws ParseException {
        String url = this.removeProtocolPrefix(jdbcUrl);
        return this.isNewFormat(url) ? this.parseNewFormat(url) : this.parseOldFormat(url);
    }

    private boolean isNewFormat(String jdbcUrl) {
        return jdbcUrl.indexOf(SERVER_PROPERTY) > -1;
    }

    public DatabaseInstance parseNewFormat(String jdbcUrl) throws ParseException {
        DatabaseInstance databaseInstance = new DatabaseInstance();
        Iterable results = Splitter.on((char)';').omitEmptyStrings().trimResults().split((CharSequence)jdbcUrl);
        for (String result : results) {
            if (result.startsWith(SERVER_PROPERTY)) {
                String serverName = result.substring(result.indexOf(SERVER_PROPERTY) + SERVER_PROPERTY.length());
                int index = serverName.indexOf(92);
                if (index > -1) {
                    serverName = serverName.substring(0, index);
                }
                databaseInstance.setHostname(serverName);
            }
            if (result.startsWith(PORT_PROPERTY)) {
                String portNumber = result.substring(result.indexOf(PORT_PROPERTY) + PORT_PROPERTY.length());
                databaseInstance.setPort(portNumber);
            }
            if (!result.startsWith(DATABASE_PROPERTY)) continue;
            String databaseName = result.substring(result.indexOf(DATABASE_PROPERTY) + DATABASE_PROPERTY.length());
            databaseInstance.setInstance(databaseName);
        }
        return databaseInstance;
    }

    private DatabaseInstance parseOldFormat(String jdbcUrl) throws ParseException {
        DatabaseInstance databaseInstance = new DatabaseInstance();
        boolean isConnectStr = true;
        for (String str : jdbcUrl.split(";")) {
            if (isConnectStr) {
                isConnectStr = false;
                String[] hostPort = str.split(":");
                databaseInstance.setHostname(this.removeInstanceName(hostPort[0]).trim());
                if (hostPort.length <= 1) continue;
                databaseInstance.setPort(hostPort[1].trim());
                continue;
            }
            if (!str.startsWith(DATABASE_PROPERTY)) continue;
            databaseInstance.setInstance(str.substring(DATABASE_PROPERTY.length()));
            break;
        }
        return databaseInstance;
    }

    @Override
    protected String getProtocolPrefix() throws ParseException {
        return MICROSOFT_DRIVER_PREFIX;
    }

    private String removeInstanceName(String str) {
        return str.split("\\\\")[0];
    }
}

