/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.feature;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.config.FeatureFlag;
import com.atlassian.jira.config.feature.FeatureFlagActivator;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;

public class CustomfieldsCleanupActivator
implements FeatureFlagActivator {
    private static final int CUSTOMFIELDS_CLEANUP_ACTIVATION_VERSION = 816000;
    private final BuildUtilsInfo buildUtilsInfo;
    private final ClusterManager clusterManager;

    public CustomfieldsCleanupActivator(ClusterManager clusterManager, BuildUtilsInfo buildUtilsInfo) {
        this.clusterManager = clusterManager;
        this.buildUtilsInfo = buildUtilsInfo;
    }

    public boolean isClusterLicensed() {
        return this.clusterManager.isClusterLicensed();
    }

    @Nonnull
    public Set<FeatureFlag> getActivatedFlags() {
        boolean databaseNumberValid;
        int databaseBuildNumber = this.buildUtilsInfo.getDatabaseBuildNumber();
        boolean bl = databaseNumberValid = databaseBuildNumber >= 816000;
        if (databaseNumberValid && this.isClusterLicensed()) {
            return ImmutableSet.of((Object)JiraFeatureFlagRegistrar.CUSTOMFIELDS_IDENTIFICATION, (Object)JiraFeatureFlagRegistrar.CUSTOMFIELDS_BULK_DELETE);
        }
        return Collections.emptySet();
    }
}

