/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.feature;

import com.atlassian.jira.config.FeatureFlag;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;

public class FeatureFlagDataProvider
implements WebResourceDataProvider {
    private final FeatureManager featureManager;
    private final ObjectMapper configuredObjectMapper;

    public FeatureFlagDataProvider(FeatureManager featureManager) {
        this.featureManager = featureManager;
        this.configuredObjectMapper = new ObjectMapper();
        this.configuredObjectMapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
    }

    public Jsonable get() {
        Set registeredFlags = this.featureManager.getRegisteredFlags();
        Map<String, Boolean> featureFlagData = registeredFlags.stream().collect(Collectors.toMap(FeatureFlag::featureKey, arg_0 -> ((FeatureManager)this.featureManager).isEnabled(arg_0)));
        Set allJiraEnabledFeatures = this.featureManager.getDarkFeatures().getAllEnabledFeatures();
        HashMap<String, Object> topLevelMap = new HashMap<String, Object>();
        topLevelMap.put("enabled-feature-keys", allJiraEnabledFeatures);
        topLevelMap.put("feature-flag-states", featureFlagData);
        return writer -> this.configuredObjectMapper.writeValue(writer, (Object)topLevelMap);
    }
}

