/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.feature;

import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.util.Supplier;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneWayDatabaseVersionFeature {
    private static final Logger log = LoggerFactory.getLogger(OneWayDatabaseVersionFeature.class);
    private final String featureName;
    private final int datbaseVersionFeatureEnabled;
    private final Supplier<Integer> currentDatabaseVersionProvider;
    private final Runnable onFeatureEnabled;
    private final AtomicBoolean featureEnabled;
    private final boolean featureDisabledViaSystemProperty;

    public OneWayDatabaseVersionFeature(String featureName, String disableFeaturePropertyName, int databaseVersionFeatureEnabled, Supplier<Integer> currentDatabaseVersionProvider, Runnable onFeatureEnabled) {
        this.featureName = featureName;
        this.datbaseVersionFeatureEnabled = databaseVersionFeatureEnabled;
        this.currentDatabaseVersionProvider = currentDatabaseVersionProvider;
        this.onFeatureEnabled = onFeatureEnabled;
        this.featureDisabledViaSystemProperty = Optional.ofNullable(JiraSystemProperties.getInstance().getBoolean(disableFeaturePropertyName)).orElse(false);
        this.featureEnabled = new AtomicBoolean(this.isFeatureEnabledInCurrentDatabaseVersion());
        if (this.featureDisabledViaSystemProperty) {
            log.info("Default mode of: {} overridden by system property value: {} = {}", new Object[]{featureName, disableFeaturePropertyName, this.featureDisabledViaSystemProperty});
        }
    }

    private boolean isFeatureEnabledInCurrentDatabaseVersion() {
        long databaseVersion = ((Integer)Optional.ofNullable(this.currentDatabaseVersionProvider.get()).orElse(0)).intValue();
        if (databaseVersion > 0L && databaseVersion < (long)this.datbaseVersionFeatureEnabled) {
            log.trace("Feature not enabled, current database version: {} and waiting for: {}", (Object)databaseVersion, (Object)this.datbaseVersionFeatureEnabled);
        }
        return databaseVersion == 0L || databaseVersion >= (long)this.datbaseVersionFeatureEnabled;
    }

    @Deprecated
    public boolean isFeatureEnabled() {
        boolean isFeatureEnabled;
        boolean bl = isFeatureEnabled = !this.featureDisabledViaSystemProperty && (this.featureEnabled.get() || this.isFeatureEnabledInCurrentDatabaseVersion());
        if (isFeatureEnabled && !this.featureEnabled.get() && this.featureEnabled.compareAndSet(false, true)) {
            log.info("Enabling feature: {}", (Object)this.featureName);
            this.onFeatureEnabled.run();
        }
        return isFeatureEnabled;
    }
}

