/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.group;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.impl.ImmutableGroup;
import com.atlassian.jira.component.pico.ComponentManager;
import com.atlassian.jira.config.group.GroupConfigurable;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class GroupConfigurationIdentifier {
    private final Supplier<ComponentManager> componentManagerSupplier;

    public GroupConfigurationIdentifier() {
        this(ComponentManager::getInstance);
    }

    @VisibleForTesting
    GroupConfigurationIdentifier(ComponentManager componentManager) {
        this(() -> componentManager);
    }

    private GroupConfigurationIdentifier(Supplier<ComponentManager> componentManagerSupplier) {
        this.componentManagerSupplier = Objects.requireNonNull(componentManagerSupplier);
    }

    private Set<GroupConfigurable> getGroupConfigurableComponents() {
        return Sets.newHashSet(this.componentManagerSupplier.get().getComponents(GroupConfigurable.class));
    }

    public boolean groupHasExistingConfiguration(@Nonnull String groupName) {
        Assertions.notNull((String)"groupName", (Object)groupName);
        ImmutableGroup group = new ImmutableGroup(groupName);
        return this.getGroupConfigurableComponents().stream().anyMatch(groupConfigurable -> groupConfigurable.isGroupUsed((Group)group));
    }
}

