/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.properties;

import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.LogoProvider;
import com.atlassian.jira.license.JiraLicenseManager;
import java.util.EnumMap;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class DefaultLogoProvider
implements LogoProvider {
    private static final EnumMap<LogoTypes, String> logos = new EnumMap(LogoTypes.class);
    private static final EnumMap<LogoTypes, String> favicons = new EnumMap(LogoTypes.class);
    private final ApplicationProperties applicationProperties;
    private final JiraLicenseManager licenseManager;

    public DefaultLogoProvider(ApplicationProperties applicationProperties, JiraLicenseManager licenseManager) {
        this.applicationProperties = applicationProperties;
        this.licenseManager = licenseManager;
    }

    public String getLogo() {
        return this.getCustomUrl("jira.lf.logo.url").orElseGet(() -> logos.get((Object)this.getActiveProduct()));
    }

    public String getFavicon() {
        return this.getCustomUrl("jira.lf.favicon.hires.url").orElseGet(() -> favicons.get((Object)this.getActiveProduct()));
    }

    private Optional<String> getCustomUrl(String key) {
        String customLogoUrl = this.applicationProperties.getString(key);
        if (!StringUtils.isEmpty((CharSequence)customLogoUrl)) {
            return Optional.of(customLogoUrl);
        }
        return Optional.empty();
    }

    private LogoTypes getActiveProduct() {
        if (this.licenseManager.isLicensed(ApplicationKeys.SOFTWARE) && this.licenseManager.isLicensed(ApplicationKeys.SERVICE_DESK)) {
            return LogoTypes.GENERIC;
        }
        if (this.licenseManager.isLicensed(ApplicationKeys.SOFTWARE)) {
            return LogoTypes.SOFTWARE;
        }
        if (this.licenseManager.isLicensed(ApplicationKeys.SERVICE_DESK)) {
            return LogoTypes.SERVICE_DESK;
        }
        return LogoTypes.CORE;
    }

    static {
        logos.put(LogoTypes.GENERIC, "/images/jira-generic.png");
        logos.put(LogoTypes.SOFTWARE, "/images/jira-software.png");
        logos.put(LogoTypes.SERVICE_DESK, "/images/jira-service-management.png");
        logos.put(LogoTypes.CORE, "/images/jira-core.png");
        logos.put(LogoTypes.ADG2, "/images/icon-jira-logo.png");
        favicons.put(LogoTypes.GENERIC, "/images/fav-generic.png");
        favicons.put(LogoTypes.SOFTWARE, "/images/fav-jsw.png");
        favicons.put(LogoTypes.SERVICE_DESK, "/images/fav-jsd.png");
        favicons.put(LogoTypes.CORE, "/images/fav-jcore.png");
        favicons.put(LogoTypes.ADG2, "/images/64jira.png");
    }

    private static enum LogoTypes {
        GENERIC,
        SOFTWARE,
        SERVICE_DESK,
        CORE,
        ADG2;

    }
}

