/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.properties;

import com.atlassian.cache.CacheManager;
import com.atlassian.core.ofbiz.util.OFBizPropertyUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventListenerRegistrar;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.feature.OneWayDatabaseVersionFeature;
import com.atlassian.jira.config.properties.DbBackedCachedPropertySetManager;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.event.JiraUpgradedEvent;
import com.atlassian.jira.propertyset.ComponentCachingOfBizPropertyEntryStore;
import com.atlassian.jira.util.Supplier;
import com.opensymphony.module.propertyset.PropertySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZDUDbBackedCachedPropertySetManager
extends DbBackedCachedPropertySetManager {
    private static final Logger log = LoggerFactory.getLogger(ZDUDbBackedCachedPropertySetManager.class);
    private static final String SYSTEM_PROPERTY_SINGLE_CACHE_JIRA_PROPERTIES_DISABLED = "com.atlassian.jira.property.set.single.cache.jira.properties.disabled";
    private static final int JIRA_VERSION_WITH_FEATURE_ENABLED = 815000;
    private final OneWayDatabaseVersionFeature oneWayDatabaseVersionFeature = new OneWayDatabaseVersionFeature(ZDUDbBackedCachedPropertySetManager.class.getName(), "com.atlassian.jira.property.set.single.cache.jira.properties.disabled", 815000, (Supplier<Integer>)((Supplier)this::getDatabaseBuildNumber), this::clearCaches);

    public ZDUDbBackedCachedPropertySetManager(QueryDslAccessor queryDslAccessor, CacheManager cacheManager, EventListenerRegistrar eventListenerRegistrar) {
        super(queryDslAccessor, cacheManager, eventListenerRegistrar);
    }

    public int getDatabaseBuildNumber() {
        String patchedVersion = super.getPropertySetSupplier().get().getString("jira.version.patched");
        if (patchedVersion == null) {
            return 0;
        }
        return Integer.parseInt(patchedVersion);
    }

    @Override
    public java.util.function.Supplier<? extends PropertySet> getPropertySetSupplier() {
        return () -> {
            if (this.oneWayDatabaseVersionFeature.isFeatureEnabled()) {
                return super.getPropertySetSupplier().get();
            }
            return OFBizPropertyUtils.getCachingPropertySet("jira.properties", 1L);
        };
    }

    @EventListener
    public void onJiraUpgradedEvent(JiraUpgradedEvent jiraUpgradedEvent) {
        this.clearCaches();
    }

    private void clearCaches() {
        log.info("Clearing caches: {}", (Object)ZDUDbBackedCachedPropertySetManager.class.getSimpleName());
        super.onClearCache(null);
        ComponentAccessor.getComponentSafely(ComponentCachingOfBizPropertyEntryStore.class).ifPresent(cachingOfBizPropertyEntryStore -> cachingOfBizPropertyEntryStore.onClearCache(null));
    }
}

