/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.webwork;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.action.SafeAction;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.config.webwork.ActionNotFoundException;
import com.atlassian.jira.config.webwork.LookupAliasActionFactoryProxy;
import com.atlassian.jira.plugin.webwork.AutowireCapableWebworkActionRegistry;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.request.RequestMethodCheckFailureException;
import com.atlassian.jira.security.request.RequestMethodCheckResult;
import com.atlassian.jira.security.request.RequestMethodChecker;
import com.atlassian.jira.security.websudo.InternalWebSudoManager;
import com.atlassian.jira.security.xsrf.XsrfCheckResult;
import com.atlassian.jira.security.xsrf.XsrfFailureException;
import com.atlassian.jira.security.xsrf.XsrfInvocationChecker;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.webwork.JiraSafeActionParameterSetter;
import com.atlassian.plugin.event.events.PluginFrameworkShutdownEvent;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.DispatcherType;
import javax.servlet.http.HttpServletRequest;
import net.jcip.annotations.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.action.Action;
import webwork.action.ActionContext;
import webwork.action.ResultException;
import webwork.action.factory.ActionFactory;
import webwork.action.factory.ActionFactoryProxy;
import webwork.action.factory.ChainingActionFactoryProxy;
import webwork.action.factory.CommandActionFactoryProxy;
import webwork.action.factory.ContextActionFactoryProxy;
import webwork.action.factory.JspActionFactoryProxy;
import webwork.action.factory.PrefixActionFactoryProxy;
import webwork.action.factory.PrepareActionFactoryProxy;
import webwork.action.factory.ReloadHelperActionFactoryProxy;
import webwork.config.Configuration;
import webwork.util.BeanUtil;
import webwork.util.ClassLoaderUtils;
import webwork.util.ValueStack;
import webwork.util.injection.ObjectFactory;

public class JiraActionFactory
extends ActionFactory {
    private static final Logger log = LoggerFactory.getLogger(JiraActionFactory.class);
    private final ActionFactory factory;
    private final JiraPluginActionFactory rootActionFactory;

    public JiraActionFactory() {
        Object factory = this.rootActionFactory = new JiraPluginActionFactory();
        factory = new PrefixActionFactoryProxy((ActionFactory)factory);
        factory = new JspActionFactoryProxy((ActionFactory)factory);
        factory = new CommandActionFactoryProxy((ActionFactory)factory);
        factory = new LookupAliasActionFactoryProxy((ActionFactory)factory);
        factory = new CommandActionFactoryProxy((ActionFactory)factory);
        factory = new ContextActionFactoryProxy((ActionFactory)factory);
        factory = new PrepareActionFactoryProxy((ActionFactory)factory);
        factory = new SafeParameterSettingActionFactoryProxy((ActionFactory)factory);
        factory = new ChainingActionFactoryProxy((ActionFactory)factory);
        try {
            boolean reloadEnabled = "true".equalsIgnoreCase(Configuration.getString((String)"webwork.configuration.xml.reload"));
            if (reloadEnabled) {
                factory = new ReloadHelperActionFactoryProxy((ActionFactory)factory);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.factory = factory;
    }

    @Deprecated
    public JiraActionFactory(ActionFactory factory, JiraPluginActionFactory rootActionFactory) {
        this.factory = factory;
        this.rootActionFactory = rootActionFactory;
    }

    private static RequestMethodChecker getRequestMethodChecker() {
        return (RequestMethodChecker)ComponentAccessor.getComponent(RequestMethodChecker.class);
    }

    public Action getActionImpl(String actionName) throws Exception {
        return this.factory.getActionImpl(actionName);
    }

    public void flushCaches() {
        this.factory.flushCaches();
        ValueStack.clearMethods();
    }

    void setPluginClassLoader(ClassLoader classLoader) {
        this.rootActionFactory.setPluginClassLoader(classLoader);
    }

    private static class JiraPluginActionFactory
    extends ActionFactory {
        private final Listener shutdownListener = new Listener();
        @ClusterSafe
        private final ConcurrentMap<String, Class<Action>> actionMappingCache = new ConcurrentHashMap<String, Class<Action>>();
        private volatile ClassLoader pluginClassLoader;
        private final ClassLoader systemClassLoader = Thread.currentThread().getContextClassLoader();

        JiraPluginActionFactory() {
        }

        @GuardedBy(value="cacheLock.readLock")
        public Action getActionImpl(String actionName) throws Exception {
            Action action;
            Class<Action> actionClass = (Class<Action>)this.actionMappingCache.get(actionName);
            if (actionClass == null) {
                actionClass = this.loadFromPluginClassLoader(actionName);
                if (actionClass == null) {
                    actionClass = this.loadFromSystemClassLoaders(actionName);
                }
                if (actionClass == null) {
                    throw new ActionNotFoundException(actionName);
                }
            }
            String actionSimpleName = actionClass.getSimpleName();
            AutowireCapableWebworkActionRegistry autowireCapableWebworkActionRegistry = this.getAutowireCapableWebworkActionRegistry();
            if (autowireCapableWebworkActionRegistry.containsAction(actionSimpleName)) {
                try {
                    action = (Action)autowireCapableWebworkActionRegistry.getPlugin(actionSimpleName).getContainerAccessor().createBean(actionClass);
                }
                catch (Exception ex) {
                    log.error("Error autowiring Action '" + actionClass.getName() + "'.", (Throwable)ex);
                    throw ex;
                }
            } else {
                action = this.instantiateAction(actionName, actionClass);
            }
            if (!JiraSystemProperties.isDevMode()) {
                this.actionMappingCache.putIfAbsent(actionName, actionClass);
            }
            return action;
        }

        private AutowireCapableWebworkActionRegistry getAutowireCapableWebworkActionRegistry() {
            return (AutowireCapableWebworkActionRegistry)ComponentAccessor.getComponentOfType(AutowireCapableWebworkActionRegistry.class);
        }

        private Action instantiateAction(String actionName, Class<? extends Action> actionClass) {
            if (!Action.class.isAssignableFrom(actionClass)) {
                throw new IllegalArgumentException("Attempt to invoke a class that is not an action '" + actionName + "'");
            }
            try {
                return (Action)ObjectFactory.instantiate(actionClass);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Action '" + actionName + "' could not be instantiated - " + e);
            }
            catch (NoClassDefFoundError e) {
                throw new IllegalArgumentException("Action '" + actionName + "' could not be instantiated. Class is invalid or static initializers have failed to run");
            }
        }

        @GuardedBy(value="cacheLock.writeLock")
        public void flushCaches() {
            this.actionMappingCache.clear();
        }

        private void setPluginClassLoader(ClassLoader classLoader) {
            this.pluginClassLoader = classLoader;
            EventPublisher eventPublisher = (EventPublisher)ComponentAccessor.getComponentOfType(EventPublisher.class);
            eventPublisher.register((Object)this.shutdownListener);
            this.flushCaches();
        }

        private Class<Action> loadFromPluginClassLoader(String name) {
            ClassLoader pluginClassLoader = this.pluginClassLoader;
            if (pluginClassLoader != null) {
                try {
                    Class<Action> result = pluginClassLoader.loadClass(name);
                    return result;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        private Class<Action> loadFromSystemClassLoaders(String name) {
            try {
                Class<Action> actionClass = this.systemClassLoader.loadClass(name);
                return actionClass;
            }
            catch (ClassNotFoundException e) {
                try {
                    return ClassLoaderUtils.loadClass((String)name, ((Object)((Object)this)).getClass());
                }
                catch (Exception e2) {
                    return null;
                }
            }
        }

        public class Listener {
            @EventListener
            public void onShutdown(PluginFrameworkShutdownEvent event) {
                JiraPluginActionFactory.this.pluginClassLoader = null;
                JiraPluginActionFactory.this.flushCaches();
            }
        }
    }

    static class SafeParameterSettingActionFactoryProxy
    extends ActionFactoryProxy {
        private final JiraSafeActionParameterSetter parameterSetter = new JiraSafeActionParameterSetter();

        SafeParameterSettingActionFactoryProxy(ActionFactory actionFactory) {
            super(actionFactory);
        }

        public Action getActionImpl(String actionAlias) throws Exception {
            Action action = this.getNextFactory().getActionImpl(actionAlias);
            if (action != null) {
                this.checkRequestMethod(action);
                this.checkXsrfStatus(action);
                this.checkWebSudoStatus(action.getClass());
                this.setActionParameters(action);
            }
            return action;
        }

        private void checkRequestMethod(Action action) {
            if (ComponentAccessor.getComponentSafely(FeatureManager.class).map(featureManager -> featureManager.isEnabled(JiraFeatureFlagRegistrar.WEBACTIONS_REQUEST_METHOD_RECOGNITION)).orElse(false).booleanValue()) {
                HttpServletRequest request = ActionContext.getRequest();
                DispatcherType dispatcherType = request.getDispatcherType();
                if (dispatcherType == DispatcherType.ERROR) {
                    return;
                }
                String method = request.getMethod();
                RequestMethodCheckResult result = JiraActionFactory.getRequestMethodChecker().checkActionInvocation(action, method);
                if (!result.isMethodSupported()) {
                    throw new RequestMethodCheckFailureException(result, action);
                }
            }
        }

        private void checkXsrfStatus(Action action) {
            Map parameters = ActionContext.getParameters();
            XsrfInvocationChecker xsrfInvocationChecker = this.getXsrfInvocationChecker();
            XsrfCheckResult xsrfCheckResult = xsrfInvocationChecker.checkActionInvocation(action, parameters);
            if (xsrfCheckResult.isRequired()) {
                boolean sessionExpired = this.sessionExpired(xsrfCheckResult);
                if (!xsrfCheckResult.isValid() || sessionExpired) {
                    throw new XsrfFailureException(action, xsrfCheckResult);
                }
            }
        }

        private void checkWebSudoStatus(Class<? extends Action> action) {
            InternalWebSudoManager webSudoManager = this.getInternalWebSudoManager();
            if (webSudoManager.isEnabled() && webSudoManager.matches(action)) {
                if (webSudoManager.hasValidSession(ActionContext.getRequest().getSession())) {
                    webSudoManager.markWebSudoRequest(ActionContext.getRequest());
                } else {
                    PermissionManager permissionManager = (PermissionManager)ComponentAccessor.getComponent(PermissionManager.class);
                    JiraAuthenticationContext jiraAuthenticationContext = (JiraAuthenticationContext)ComponentAccessor.getComponent(JiraAuthenticationContext.class);
                    if (jiraAuthenticationContext.getUser() == null && permissionManager.hasPermission(0, (ApplicationUser)null)) {
                        webSudoManager.startSession(ActionContext.getRequest(), ActionContext.getResponse());
                    } else {
                        throw new WebSudoSessionException("No websudo session and it is required");
                    }
                }
            }
        }

        private boolean sessionExpired(XsrfCheckResult xsrfCheckResult) {
            ApplicationUser currentUser = this.getAuthenticationContext().getUser();
            return xsrfCheckResult.isGeneratedForAuthenticatedUser() && currentUser == null;
        }

        JiraAuthenticationContext getAuthenticationContext() {
            return (JiraAuthenticationContext)ComponentAccessor.getComponent(JiraAuthenticationContext.class);
        }

        XsrfInvocationChecker getXsrfInvocationChecker() {
            return (XsrfInvocationChecker)ComponentAccessor.getComponent(XsrfInvocationChecker.class);
        }

        InternalWebSudoManager getInternalWebSudoManager() {
            return (InternalWebSudoManager)ComponentAccessor.getComponent(InternalWebSudoManager.class);
        }

        private void setActionParameters(Action action) throws ResultException {
            Map parameters = ActionContext.getParameters();
            if (log.isDebugEnabled()) {
                this.debugActionParameters(action, parameters);
            }
            try {
                if (action instanceof SafeAction) {
                    BeanUtil.setProperties((Map)parameters, (Object)action);
                } else {
                    this.parameterSetter.setSafeParameters(action, parameters);
                }
            }
            catch (IllegalArgumentException iae) {
                throw new ResultException("error");
            }
        }

        private <C extends Comparable<C>> void debugActionParameters(Action action, Map<C, ?> parameters) {
            Set<C> keySet;
            if (log.isDebugEnabled() && action != null && !(keySet = parameters.keySet()).isEmpty()) {
                ArrayList<C> keys = new ArrayList<C>(keySet);
                Collections.sort(keys);
                String requestURL = "BackEnd Action";
                if (ActionContext.getRequest() != null && ActionContext.getRequest().getRequestURL() != null) {
                    requestURL = ActionContext.getRequest().getRequestURL().toString();
                }
                log.debug("JAFP " + action.getClass().getName() + " - " + requestURL);
                for (Object key : keys) {
                    log.debug("JAFP param=" + key + " value" + this.valStr(parameters.get(key)));
                }
                log.debug("JAFP ------");
            }
        }

        private String valStr(Object value) {
            StringBuilder sb = new StringBuilder();
            if (value != null) {
                sb.append(value.getClass().getName()).append(" - ");
            }
            if (value instanceof String[]) {
                for (String val : (String[])value) {
                    sb.append(val).append(", ");
                }
            } else {
                sb.append(value);
            }
            return sb.toString();
        }
    }
}

