/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.model.membership.MembershipType;
import java.io.Serializable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

final class MembershipKey
implements Serializable {
    private static final long serialVersionUID = -1089403757434661088L;
    private final long directoryId;
    private final String name;
    private final MembershipType type;

    private MembershipKey(long directoryId, String name, MembershipType type) {
        this.directoryId = directoryId;
        this.name = name;
        this.type = type;
    }

    public long getDirectoryId() {
        return this.directoryId;
    }

    public String getName() {
        return this.name;
    }

    public MembershipType getType() {
        return this.type;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MembershipKey)) {
            return false;
        }
        MembershipKey other = (MembershipKey)o;
        return this.directoryId == other.directoryId && this.type == other.type && this.name.equals(other.name);
    }

    public int hashCode() {
        int result = (int)(this.directoryId ^ this.directoryId >>> 32);
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static MembershipKey getKey(long directoryId, String name, MembershipType type) {
        return new MembershipKey(directoryId, IdentifierUtils.toLowerCase((String)name), type);
    }
}

