/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.crowd.event.application.ApplicationDirectoryOrderUpdatedEvent;
import com.atlassian.crowd.event.directory.DirectoryCreatedEvent;
import com.atlassian.crowd.event.directory.DirectoryDeletedEvent;
import com.atlassian.crowd.event.directory.DirectoryUpdatedEvent;
import com.atlassian.crowd.event.migration.XMLRestoreFinishedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.crowd.embedded.ofbiz.ExtendedUserDao;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizApplicationDao;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizDirectoryDao;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizGroupDao;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizInternalMembershipDao;
import com.atlassian.jira.event.ClearCacheEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OfBizCacheFlushingManager {
    private static final Logger log = LoggerFactory.getLogger(OfBizCacheFlushingManager.class);
    private final OfBizCacheFlushingManagerListener ofBizCacheFlushingManagerListener;

    public OfBizCacheFlushingManager(EventPublisher eventPublisher, ExtendedUserDao ofBizUserDao, OfBizDirectoryDao ofBizDirectoryDao, OfBizGroupDao ofBizGroupDao, OfBizInternalMembershipDao ofBizInternalMembershipDao, OfBizApplicationDao ofBizApplicationDao) {
        this.ofBizCacheFlushingManagerListener = new OfBizCacheFlushingManagerListener(ofBizUserDao, ofBizDirectoryDao, ofBizGroupDao, ofBizInternalMembershipDao, ofBizApplicationDao);
        eventPublisher.register((Object)this.ofBizCacheFlushingManagerListener);
    }

    public static final class OfBizCacheFlushingManagerListener {
        private final ExtendedUserDao ofBizUserDao;
        private final OfBizDirectoryDao ofBizDirectoryDao;
        private final OfBizGroupDao ofBizGroupDao;
        private final OfBizInternalMembershipDao ofBizInternalMembershipDao;
        private final OfBizApplicationDao ofBizApplicationDao;

        private OfBizCacheFlushingManagerListener(ExtendedUserDao ofBizUserDao, OfBizDirectoryDao ofBizDirectoryDao, OfBizGroupDao ofBizGroupDao, OfBizInternalMembershipDao ofBizInternalMembershipDao, OfBizApplicationDao ofBizApplicationDao) {
            this.ofBizUserDao = ofBizUserDao;
            this.ofBizDirectoryDao = ofBizDirectoryDao;
            this.ofBizGroupDao = ofBizGroupDao;
            this.ofBizInternalMembershipDao = ofBizInternalMembershipDao;
            this.ofBizApplicationDao = ofBizApplicationDao;
        }

        @EventListener
        public void onEvent(XMLRestoreFinishedEvent event) {
            this.flushAllCachesInCorrectOrder(event);
        }

        @EventListener
        public void onEvent(DirectoryCreatedEvent event) {
            this.flushAllCachesInCorrectOrder(event);
        }

        @EventListener
        public void onEvent(DirectoryDeletedEvent event) {
            this.flushAllCachesInCorrectOrder(event);
        }

        @EventListener
        public void onEvent(DirectoryUpdatedEvent event) {
            if (event.getOldDirectory().isActive() != event.getDirectory().isActive()) {
                this.flushAllCachesInCorrectOrder(event);
            }
        }

        @EventListener
        public void onEvent(ApplicationDirectoryOrderUpdatedEvent event) {
            this.flushAllCachesInCorrectOrder(event);
        }

        @EventListener
        public void onEvent(ClearCacheEvent event) {
            this.flushAllCachesInCorrectOrder(event);
        }

        private void flushAllCachesInCorrectOrder(Object event) {
            log.info("Flushing application, directory, user, group and membership caches on {}", (Object)event.getClass().getSimpleName());
            this.ofBizApplicationDao.flushCache();
            this.ofBizDirectoryDao.flushCache();
            this.ofBizUserDao.flushCache();
            this.ofBizGroupDao.flushCache();
            this.ofBizInternalMembershipDao.flushCache();
            log.info("Done flushing application, directory, user, group and membership caches on {}", (Object)event.getClass().getSimpleName());
        }
    }
}

