/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.crowd.directory.DirectorySynchronisationStatusImpl;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.embedded.spi.DirectorySynchronisationStatusDao;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.crowd.model.directory.DirectorySynchronisationStatus;
import com.atlassian.crowd.model.directory.SynchronisationStatusKey;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.model.querydsl.DirectorySynchronisationStatusDTO;
import com.atlassian.jira.model.querydsl.QDirectorySynchronisationStatus;
import com.google.common.base.Preconditions;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.ComparableExpressionBase;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class OfBizDirectorySynchronisationStatusDao
implements DirectorySynchronisationStatusDao {
    private final QueryDslAccessor queryDslAccessor;
    private final DirectoryDao directoryDao;

    public OfBizDirectorySynchronisationStatusDao(QueryDslAccessor queryDslAccessor, DirectoryDao directoryDao) {
        this.queryDslAccessor = queryDslAccessor;
        this.directoryDao = directoryDao;
    }

    public Optional<DirectorySynchronisationStatus> findActiveForDirectory(long directoryId) {
        return this.findForDirectory(SimpleExpression::isNull, ComparableExpressionBase::desc, directoryId);
    }

    public Optional<DirectorySynchronisationStatus> findLastForDirectory(long directoryId) {
        return this.findForDirectory(SimpleExpression::isNotNull, ComparableExpressionBase::asc, directoryId);
    }

    private Optional<DirectorySynchronisationStatus> findForDirectory(Function<SimpleExpression<?>, Predicate> endTimestampPredicateFunct, Function<NumberExpression<?>, OrderSpecifier<?>> startTimestampOrderSpecifierFunct, long directoryId) {
        DirectorySynchronisationStatusDTO dto = this.queryDslAccessor.executeQuery(dbConnection -> (DirectorySynchronisationStatusDTO)((SQLQuery)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)QDirectorySynchronisationStatus.DIRECTORY_SYNCHRONISATION_STATUS).from((Expression)QDirectorySynchronisationStatus.DIRECTORY_SYNCHRONISATION_STATUS)).where((Predicate)QDirectorySynchronisationStatus.DIRECTORY_SYNCHRONISATION_STATUS.directoryId.eq((Object)directoryId).and((Predicate)endTimestampPredicateFunct.apply((SimpleExpression<?>)QDirectorySynchronisationStatus.DIRECTORY_SYNCHRONISATION_STATUS.endTimestamp)))).orderBy((OrderSpecifier)startTimestampOrderSpecifierFunct.apply((NumberExpression<?>)QDirectorySynchronisationStatus.DIRECTORY_SYNCHRONISATION_STATUS.startTimestamp))).fetchFirst());
        return Optional.ofNullable(dto).map(this::makeDirectorySynchronisationStatus);
    }

    public DirectorySynchronisationStatus add(DirectorySynchronisationStatus status) {
        DirectorySynchronisationStatusDTO dto = new DirectorySynchronisationStatusDTO(null, status.getDirectory().getId(), status.getNodeId(), status.getStartTimestamp(), status.getEndTimestamp(), status.getStatus().toString(), status.getStatusParameters());
        Long id = this.queryDslAccessor.executeQuery(dbConnection -> dbConnection.insert(QDirectorySynchronisationStatus.DIRECTORY_SYNCHRONISATION_STATUS).populate(dto).executeWithId());
        return DirectorySynchronisationStatusImpl.builder().setId(Integer.valueOf(id.intValue())).setDirectory(status.getDirectory()).setStartTimestamp(Long.valueOf(status.getStartTimestamp())).setEndTimestamp(status.getEndTimestamp()).setStatus(status.getStatus(), status.getStatusParameters()).setNodeId(status.getNodeId()).build();
    }

    public DirectorySynchronisationStatus update(DirectorySynchronisationStatus status) throws ObjectNotFoundException {
        Preconditions.checkNotNull((Object)status.getId(), (Object)"Tried to update DirectorySynchronisationStatus without an id");
        DirectorySynchronisationStatusDTO dto = new DirectorySynchronisationStatusDTO(status.getId().longValue(), status.getDirectory().getId(), status.getNodeId(), status.getStartTimestamp(), status.getEndTimestamp(), status.getStatus().toString(), status.getStatusParameters());
        this.queryDslAccessor.executeQuery(dbConnection -> dbConnection.update((RelationalPath<?>)QDirectorySynchronisationStatus.DIRECTORY_SYNCHRONISATION_STATUS).populate((Object)dto).where((Predicate)QDirectorySynchronisationStatus.DIRECTORY_SYNCHRONISATION_STATUS.id.eq((Object)dto.getId())).execute());
        return status;
    }

    public long removeStatusesForDirectory(Long directoryId) {
        return this.queryDslAccessor.executeQuery(dbConnection -> dbConnection.delete((RelationalPath<?>)QDirectorySynchronisationStatus.DIRECTORY_SYNCHRONISATION_STATUS).where((Predicate)QDirectorySynchronisationStatus.DIRECTORY_SYNCHRONISATION_STATUS.directoryId.eq((Object)directoryId)).execute());
    }

    public long removeAll() {
        return this.queryDslAccessor.executeQuery(dbConnection -> dbConnection.delete((RelationalPath<?>)QDirectorySynchronisationStatus.DIRECTORY_SYNCHRONISATION_STATUS).execute());
    }

    public long removeAllExcept(long directoryId, int statusId) {
        return this.queryDslAccessor.executeQuery(dbConnection -> dbConnection.delete((RelationalPath<?>)QDirectorySynchronisationStatus.DIRECTORY_SYNCHRONISATION_STATUS).where((Predicate)QDirectorySynchronisationStatus.DIRECTORY_SYNCHRONISATION_STATUS.directoryId.eq((Object)directoryId).and((Predicate)QDirectorySynchronisationStatus.DIRECTORY_SYNCHRONISATION_STATUS.id.ne((Object)statusId))).execute());
    }

    public Collection<DirectorySynchronisationStatus> findActiveSyncsWhereNodeIdNotIn(Set<String> nodesIds) {
        List dtos = this.queryDslAccessor.executeQuery(dbConnection -> ((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)QDirectorySynchronisationStatus.DIRECTORY_SYNCHRONISATION_STATUS).from((Expression)QDirectorySynchronisationStatus.DIRECTORY_SYNCHRONISATION_STATUS)).where((Predicate)QDirectorySynchronisationStatus.DIRECTORY_SYNCHRONISATION_STATUS.nodeId.notIn((Collection)nodesIds).and((Predicate)QDirectorySynchronisationStatus.DIRECTORY_SYNCHRONISATION_STATUS.endTimestamp.isNull()))).fetch());
        return dtos.stream().map(this::makeDirectorySynchronisationStatus).collect(Collectors.toList());
    }

    private DirectorySynchronisationStatus makeDirectorySynchronisationStatus(DirectorySynchronisationStatusDTO dto) {
        try {
            return DirectorySynchronisationStatusImpl.builder().setId(Integer.valueOf(dto.getId().intValue())).setDirectory(this.directoryDao.findById(dto.getDirectoryId().longValue())).setStartTimestamp(dto.getStartTimestamp()).setEndTimestamp(dto.getEndTimestamp()).setStatus(SynchronisationStatusKey.valueOf((String)dto.getStatus()), dto.getStatusParameters()).setNodeId(dto.getNodeId()).build();
        }
        catch (DirectoryNotFoundException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }
}

