/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupComparator;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.InternalDirectoryGroup;
import com.atlassian.jira.crowd.embedded.ofbiz.UserOrGroupStub;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.BooleanUtils;
import org.ofbiz.core.entity.GenericValue;

class OfBizGroup
implements InternalDirectoryGroup,
UserOrGroupStub,
Serializable {
    private static final long serialVersionUID = -3507906061639787167L;
    static final List<String> SUPPORTED_FIELDS = ImmutableList.builder().add((Object)"id").add((Object)"directoryId").add((Object)"groupName").add((Object)"active").add((Object)"local").add((Object)"createdDate").add((Object)"updatedDate").add((Object)"type").add((Object)"description").add((Object)"externalId").build();
    private final long id;
    private final long directoryId;
    private final String name;
    private final boolean active;
    private final boolean local;
    private final Date createdDate;
    private final Date updatedDate;
    private final GroupType groupType;
    private final String description;
    private final String externalId;
    private String lowerName;
    private int hash;

    static OfBizGroup from(GenericValue groupGenericValue) {
        return new OfBizGroup((GenericValue)Assertions.notNull((Object)groupGenericValue));
    }

    @VisibleForTesting
    OfBizGroup(long id, long directoryId, String name, boolean active, boolean local, Date createdDate, Date updatedDate, GroupType groupType, String description, String externalId) {
        this.id = id;
        this.directoryId = directoryId;
        this.name = name;
        this.active = active;
        this.local = local;
        this.createdDate = createdDate;
        this.updatedDate = updatedDate;
        this.groupType = groupType;
        this.description = description;
        this.externalId = externalId;
    }

    private OfBizGroup(GenericValue groupGenericValue) {
        this(groupGenericValue.getLong("id"), groupGenericValue.getLong("directoryId"), groupGenericValue.getString("groupName"), BooleanUtils.toBoolean((int)groupGenericValue.getInteger("active")), BooleanUtils.toBoolean((int)groupGenericValue.getInteger("local")), groupGenericValue.getTimestamp("createdDate"), groupGenericValue.getTimestamp("updatedDate"), GroupType.valueOf((String)groupGenericValue.getString("type")), groupGenericValue.getString("description"), groupGenericValue.getString("externalId"));
    }

    @Override
    public long getId() {
        return this.id;
    }

    public GroupType getType() {
        return this.groupType;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getDescription() {
        return this.description;
    }

    @Nullable
    public String getExternalId() {
        return this.externalId;
    }

    public long getDirectoryId() {
        return this.directoryId;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getLowerName() {
        String lower = this.lowerName;
        if (lower == null) {
            this.lowerName = lower = IdentifierUtils.toLowerCase((String)this.name);
        }
        return lower;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public Date getUpdatedDate() {
        return this.updatedDate;
    }

    public boolean isLocal() {
        return this.local;
    }

    public final boolean equals(Object o) {
        return o instanceof Group && GroupComparator.equal((Group)this, (Group)((Group)o));
    }

    public final int hashCode() {
        int h = this.hash;
        if (h == 0) {
            this.hash = h = GroupComparator.hashCode((Group)this);
        }
        return this.hash;
    }

    public int compareTo(@Nonnull Group other) {
        return GroupComparator.compareTo((Group)this, (Group)other);
    }

    public String toString() {
        return "Group[" + this.name + ':' + this.directoryId + ']';
    }
}

