/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.beehive.ClusterLockService;
import com.atlassian.cache.CacheManager;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.embedded.spi.GroupDao;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.model.DirectoryEntity;
import com.atlassian.crowd.model.group.DelegatingGroupWithAttributes;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.model.group.InternalDirectoryGroup;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.util.BatchResult;
import com.atlassian.jira.cluster.cache.pauser.ClusteredReplicationPauserManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.crowd.embedded.ofbiz.DirectoryEntityKey;
import com.atlassian.jira.crowd.embedded.ofbiz.EagerOfBizGroupCache;
import com.atlassian.jira.crowd.embedded.ofbiz.ExponentialBatchProcessingUtil;
import com.atlassian.jira.crowd.embedded.ofbiz.GroupAttributeEntity;
import com.atlassian.jira.crowd.embedded.ofbiz.GroupDaoStats;
import com.atlassian.jira.crowd.embedded.ofbiz.GroupEntity;
import com.atlassian.jira.crowd.embedded.ofbiz.GroupEntityConditionFactory;
import com.atlassian.jira.crowd.embedded.ofbiz.GroupNotFoundException;
import com.atlassian.jira.crowd.embedded.ofbiz.InternalMembershipDao;
import com.atlassian.jira.crowd.embedded.ofbiz.LazyOfBizGroupCache;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizAttributesBuilder;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizGroup;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizGroupCache;
import com.atlassian.jira.crowd.embedded.ofbiz.PrimitiveMap;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.stats.JiraStats;
import com.google.common.base.Stopwatch;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Sets;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfBizGroupDao
implements GroupDao {
    private static final Logger log = LoggerFactory.getLogger(OfBizGroupDao.class);
    private final OfBizDelegator ofBizDelegator;
    private final InternalMembershipDao membershipDao;
    private final OfBizGroupCache groupCaseInsensitiveCache;
    private final GroupDaoStats groupDaoStats;
    private final boolean eagerCache;
    private final boolean findByNameOrNullSkipRefreshOnNull = JiraSystemProperties.getInstance().getBoolean("com.atlassian.jira.crowd.embedded.ofbiz.OfBizGroupDao.findByNameOrNullSkipRefreshOnNull");
    private final LoadingCache<String, List<OfBizGroup>> groupCacheForcedReloadsOnNull = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(15L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, List<OfBizGroup>>(){

        public List<OfBizGroup> load(String groupName) throws Exception {
            return OfBizGroupDao.this.findGroupsGenericValue(groupName);
        }
    });
    static final Function<GenericValue, String> TO_GROUPNAME_FUNCTION = gv -> gv.getString("groupName");
    static final Function<GenericValue, OfBizGroup> TO_GROUP_FUNCTION = OfBizGroup::from;
    final Function<GenericValue, GroupWithAttributes> toGroupWithAttributesFunction = gv -> this.withAttributes((OfBizGroup)TO_GROUP_FUNCTION.apply(gv));

    public OfBizGroupDao(OfBizDelegator ofBizDelegator, DirectoryDao directoryDao, InternalMembershipDao membershipDao, CacheManager cacheManager, ClusterLockService clusterLockService, ApplicationProperties applicationProperties) {
        this.ofBizDelegator = ofBizDelegator;
        this.membershipDao = membershipDao;
        this.groupDaoStats = JiraStats.create(GroupDaoStats.class, GroupDaoStats::create, false);
        if (applicationProperties.getOption("jira.fullUserCache")) {
            this.groupCaseInsensitiveCache = new EagerOfBizGroupCache(clusterLockService, cacheManager, directoryDao, ofBizDelegator);
            this.eagerCache = true;
        } else {
            this.groupCaseInsensitiveCache = new LazyOfBizGroupCache(cacheManager, ofBizDelegator);
            this.eagerCache = false;
        }
        this.groupDaoStats.settings(this.eagerCache, this.findByNameOrNullSkipRefreshOnNull);
    }

    @Nonnull
    public InternalDirectoryGroup findByName(long directoryId, @Nonnull String name) throws GroupNotFoundException {
        return this.findOfBizGroup(directoryId, name);
    }

    @Nonnull
    OfBizGroup findOfBizGroup(long directoryId, String name) throws GroupNotFoundException {
        OfBizGroup group = this.findByNameOrNull(directoryId, name);
        if (group == null) {
            throw new GroupNotFoundException(name);
        }
        return group;
    }

    @Nullable
    OfBizGroup findByNameOrNull(long directoryId, String name) {
        this.groupDaoStats.settings(this.eagerCache, this.findByNameOrNullSkipRefreshOnNull);
        this.groupDaoStats.findByNameOrNull();
        OfBizGroup result = this.groupCaseInsensitiveCache.getCaseInsensitive(directoryId, name);
        if (result != null) {
            this.groupDaoStats.findByNameOrNullCacheHit();
            return result;
        }
        if (!this.eagerCache || this.findByNameOrNullSkipRefreshOnNull) {
            return result;
        }
        log.trace("Cache miss in group cache for group: [directoryId:{}, name:{}]", new Object[]{directoryId, name, new Exception()});
        this.groupDaoStats.findByNameOrNullCacheMiss();
        Stopwatch stopwatch = Stopwatch.createStarted();
        List groupsWithName = (List)this.groupCacheForcedReloadsOnNull.getUnchecked((Object)name);
        new ClusteredReplicationPauserManager().pauseReplicationFor(() -> {
            for (OfBizGroup group : groupsWithName) {
                this.groupCaseInsensitiveCache.refresh(group);
            }
        }, "GroupDao#findByNameOrNull");
        OfBizGroup resultBis = this.groupCaseInsensitiveCache.getCaseInsensitive(directoryId, name);
        if (resultBis != null) {
            log.debug("Fixed group cache inconsistency. Group: [directoryId:{}, name:{}] was missing from cache but found in DB.", (Object)directoryId, (Object)name);
            this.groupDaoStats.findByNameOrNullDBHit(stopwatch.elapsed(TimeUnit.MILLISECONDS));
            return resultBis;
        }
        this.groupDaoStats.findByNameOrNullDBMiss(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return null;
    }

    public GroupWithAttributes findByNameWithAttributes(long directoryId, String name) throws GroupNotFoundException {
        return this.withAttributes(this.findOfBizGroup(directoryId, name));
    }

    private GroupWithAttributes withAttributes(OfBizGroup group) {
        List<GenericValue> attributes = Select.columns(OfBizAttributesBuilder.SUPPORTED_FIELDS).from("GroupAttribute").whereEqual("directoryId", group.getDirectoryId()).andEqual("groupId", group.getId()).runWith(this.ofBizDelegator).asList();
        return new DelegatingGroupWithAttributes((Group)group, OfBizAttributesBuilder.toAttributes(attributes));
    }

    public Group add(Group group) {
        return this.add(group, false);
    }

    public Group addLocal(Group group) {
        return this.add(group, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Group add(Group group, boolean local) {
        try {
            Timestamp currentTimestamp = OfBizGroupDao.getCurrentTimestamp();
            Map<String, Object> groupData = GroupEntity.getData(group, currentTimestamp, currentTimestamp, local);
            GenericValue gvGroup = this.ofBizDelegator.createValue("Group", groupData);
            OfBizGroup ofBizGroup = OfBizGroup.from(gvGroup);
            this.groupCaseInsensitiveCache.refresh(ofBizGroup);
            return ofBizGroup;
        }
        catch (DataAccessException e) {
            this.groupDaoStats.groupAddFailed();
            log.trace("[GroupDao:add] Failed to add group: {}, local: {}, error: {}", new Object[]{group, local, e.getMessage(), e});
            log.info("[GroupDao:add] Assume the group: {} exist, try updating...", (Object)group);
            ClusteredReplicationPauserManager context = new ClusteredReplicationPauserManager();
            String contextName = "group refresh: " + group;
            context.start(contextName);
            try {
                Group update = this.update(group);
                this.groupDaoStats.groupAddFailedUpdateSuccessful();
                Group group2 = update;
                context.stop(contextName);
                return group2;
            }
            catch (Throwable throwable) {
                try {
                    context.stop(contextName);
                    throw throwable;
                }
                catch (GroupNotFoundException notFoundException) {
                    this.groupDaoStats.groupAddFailedUpdateFailed();
                    log.trace("[GroupDao:add] Failed updating group: {}, error: {}. Re-throwing original \"create\" exception: {}", new Object[]{notFoundException.getMessage(), notFoundException, e.getMessage()});
                    throw e;
                }
            }
        }
    }

    public BatchResult<Group> addAll(Set<? extends Group> groups) throws DirectoryNotFoundException {
        BatchResult results = new BatchResult(groups.size());
        for (Group group : groups) {
            try {
                Group addedGroup = this.add(group);
                results.addSuccess((Object)addedGroup);
            }
            catch (DataAccessException e) {
                results.addFailure((Object)group);
                log.debug("Data error trying to add group '{}'", (Object)group.getName(), (Object)e);
            }
        }
        return results;
    }

    public Group update(Group group) throws GroupNotFoundException {
        GenericValue groupGenericValue = this.findGroupGenericValue(group);
        groupGenericValue.set("active", (Object)BooleanUtils.toInteger((boolean)group.isActive()));
        groupGenericValue.set("updatedDate", (Object)OfBizGroupDao.getCurrentTimestamp());
        groupGenericValue.set("description", (Object)group.getDescription());
        groupGenericValue.set("lowerDescription", (Object)OfBizGroupDao.toLowerCaseAllowNull(group.getDescription()));
        groupGenericValue.set("externalId", (Object)group.getExternalId());
        try {
            this.storeGroup(groupGenericValue);
            OfBizGroup ofBizGroup = OfBizGroup.from(groupGenericValue);
            this.groupCaseInsensitiveCache.refresh(ofBizGroup);
            return ofBizGroup;
        }
        catch (DataAccessException dataAccessException) {
            throw new GroupNotFoundException(group.getName(), dataAccessException);
        }
    }

    private void storeGroup(GenericValue groupGenericValue) {
        if (groupGenericValue.get("description") != null && ((String)groupGenericValue.get("description")).length() > 255) {
            groupGenericValue.set("description", (Object)GroupEntity.truncateDescriptionIfRequired(groupGenericValue.getString("description")));
        }
        if (groupGenericValue.get("lowerDescription") != null && ((String)groupGenericValue.get("lowerDescription")).length() > 255) {
            groupGenericValue.set("lowerDescription", (Object)GroupEntity.truncateDescriptionIfRequired(groupGenericValue.getString("lowerDescription")));
        }
        this.ofBizDelegator.store(groupGenericValue);
    }

    public Group rename(Group group, String newName) {
        throw new UnsupportedOperationException("Renaming groups is not supported!");
    }

    public void storeAttributes(Group group, Map<String, Set<String>> attributes) throws GroupNotFoundException {
        for (Map.Entry attribute : ((Map)Assertions.notNull(attributes)).entrySet()) {
            this.removeAttribute(group, (String)attribute.getKey());
            if (attribute.getValue() == null || ((Set)attribute.getValue()).isEmpty()) continue;
            this.storeAttributeValues(group, (String)attribute.getKey(), (Set)attribute.getValue());
        }
    }

    private void storeAttributeValues(Group group, String name, Set<String> values) throws GroupNotFoundException {
        for (String value : values) {
            if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
            this.storeAttributeValue(group, name, value);
        }
    }

    private void storeAttributeValue(Group group, String name, String value) throws GroupNotFoundException {
        GenericValue groupGenericValue = this.findGroupGenericValue(group);
        this.ofBizDelegator.createValue("GroupAttribute", GroupAttributeEntity.getData(group.getDirectoryId(), groupGenericValue.getLong("id"), name, value));
    }

    public void removeAttribute(Group group, String attributeName) throws GroupNotFoundException {
        Assertions.notNull((Object)attributeName);
        GenericValue gv = this.findGroupGenericValue(group);
        this.ofBizDelegator.removeByAnd("GroupAttribute", PrimitiveMap.of("groupId", (long)gv.getLong("id"), "name", attributeName));
    }

    public void remove(Group group) throws GroupNotFoundException {
        GenericValue groupGenericValue = this.findGroupGenericValue(group);
        try {
            this.membershipDao.removeAllMembersFromGroup(group);
            this.membershipDao.removeAllGroupMemberships(group);
            this.ofBizDelegator.removeByAnd("GroupAttribute", PrimitiveMap.of("groupId", groupGenericValue.getLong("id")));
            this.ofBizDelegator.removeValue(groupGenericValue);
        }
        finally {
            this.groupCaseInsensitiveCache.remove(DirectoryEntityKey.getKeyLowerCase((DirectoryEntity)group));
        }
    }

    public <T> List<T> search(long directoryId, EntityQuery<T> query) {
        Validate.notNull(query);
        Validate.isTrue((query.getEntityDescriptor().getEntityType() == Entity.GROUP ? 1 : 0) != 0, (String)"GroupDao can only evaluate EntityQueries for Entity.GROUP", (Object[])new Object[0]);
        SearchRestriction searchRestriction = query.getSearchRestriction();
        EntityCondition baseCondition = new GroupEntityConditionFactory(this.ofBizDelegator).getEntityConditionFor(searchRestriction);
        EntityExpr directoryCondition = new EntityExpr("directoryId", EntityOperator.EQUALS, (Object)directoryId);
        ArrayList<Object> entityConditions = new ArrayList<Object>(2);
        if (baseCondition != null) {
            entityConditions.add(baseCondition);
        }
        entityConditions.add(directoryCondition);
        EntityConditionList entityCondition = new EntityConditionList(entityConditions, EntityOperator.AND);
        Function<GenericValue, T> valueFunction = this.getTransformer(query.getReturnType());
        List<T> results = Select.from("Group").whereCondition((EntityCondition)entityCondition).orderBy("groupName").limit(query.getStartIndex(), query.getMaxResults()).runWith(this.ofBizDelegator).asList(valueFunction);
        return results;
    }

    private <T> Function<GenericValue, T> getTransformer(Class<T> returnType) {
        if (returnType.equals(String.class)) {
            return TO_GROUPNAME_FUNCTION;
        }
        if (returnType.isAssignableFrom(OfBizGroup.class)) {
            return TO_GROUP_FUNCTION;
        }
        if (returnType.isAssignableFrom(GroupWithAttributes.class)) {
            return this.toGroupWithAttributesFunction;
        }
        throw new IllegalArgumentException("Class type for return values ('" + returnType + "') is not supported");
    }

    public BatchResult<String> removeAllGroups(long directoryId, Set<String> groupNames) {
        BatchResult results = new BatchResult(groupNames.size());
        for (String groupName : groupNames) {
            try {
                this.remove((Group)this.findByName(directoryId, groupName));
                results.addSuccess((Object)groupName);
            }
            catch (GroupNotFoundException e) {
                results.addFailure((Object)groupName);
                log.debug("Group '{}' not found", (Object)groupName, (Object)e);
            }
        }
        return results;
    }

    public Set<String> getAllExternalIds(long directoryId) throws DirectoryNotFoundException {
        TreeSet result = Sets.newTreeSet();
        EntityExpr directoryIdCond = new EntityExpr("directoryId", EntityOperator.EQUALS, (Object)directoryId);
        EntityExpr notNullExternalIdCond = new EntityExpr("externalId", EntityOperator.NOT_EQUAL, null);
        EntityExpr condition = new EntityExpr((EntityCondition)directoryIdCond, EntityOperator.AND, (EntityCondition)notNullExternalIdCond);
        Select.from("Group").whereCondition((EntityCondition)condition).runWith(this.ofBizDelegator).forEach(gv -> result.add(gv.getString("externalId")));
        return result;
    }

    public long getGroupCount(long directoryId) throws DirectoryNotFoundException {
        return Select.from("Group").whereEqual("directoryId", directoryId).runWith(this.ofBizDelegator).count();
    }

    public Set<String> getLocalGroupNames(long directoryId) throws DirectoryNotFoundException {
        TreeSet result = Sets.newTreeSet();
        Select.from("Group").whereEqual("directoryId", directoryId).andCondition((EntityCondition)new EntityExpr("local", EntityOperator.EQUALS, (Object)BooleanUtils.toIntegerObject((boolean)true))).runWith(this.ofBizDelegator).forEach(gv -> result.add(gv.getString("groupName")));
        return result;
    }

    public Map<String, String> findByExternalIds(long directoryId, Set<String> externalIds) {
        ExponentialBatchProcessingUtil.BatchProcessor operation = (resultAccumulator, batch) -> {
            Select.columns("externalId", "groupName").from("Group").whereEqual("directoryId", directoryId).andCondition((EntityCondition)new EntityExpr("externalId", EntityOperator.IN, (Object)batch)).runWith(this.ofBizDelegator).forEach(gv -> resultAccumulator.put(gv.getString("externalId"), gv.getString("groupName")));
            return resultAccumulator;
        };
        return ExponentialBatchProcessingUtil.processBatches(externalIds, HashMap::new, operation);
    }

    public Map<String, String> findExternalIdsByNames(long directoryId, Set<String> names) {
        ExponentialBatchProcessingUtil.BatchProcessor operation = (resultAccumulator, batch) -> {
            Select.columns("externalId", "groupName").from("Group").whereEqual("directoryId", directoryId).andCondition((EntityCondition)new EntityExpr("externalId", EntityOperator.NOT_EQUAL, null)).andCondition((EntityCondition)new EntityExpr("groupName", EntityOperator.IN, (Object)batch)).runWith(this.ofBizDelegator).forEach(gv -> resultAccumulator.put(gv.getString("groupName"), gv.getString("externalId")));
            return resultAccumulator;
        };
        return ExponentialBatchProcessingUtil.processBatches(names, HashMap::new, operation);
    }

    public long getExternalGroupCount(long directoryId) throws DirectoryNotFoundException {
        EntityExpr directoryIdCond = new EntityExpr("directoryId", EntityOperator.EQUALS, (Object)directoryId);
        EntityExpr notNullExternalIdCond = new EntityExpr("externalId", EntityOperator.NOT_EQUAL, null);
        EntityExpr condition = new EntityExpr((EntityCondition)directoryIdCond, EntityOperator.AND, (EntityCondition)notNullExternalIdCond);
        return Select.from("Group").whereCondition((EntityCondition)condition).runWith(this.ofBizDelegator).count();
    }

    public void flushCache() {
        this.groupCaseInsensitiveCache.refresh();
    }

    private GenericValue findGroupGenericValue(Group group) throws GroupNotFoundException {
        return this.findGroupGenericValue(group.getDirectoryId(), group.getName());
    }

    GenericValue findGroupGenericValue(long directoryId, String name) throws GroupNotFoundException {
        Assertions.notNull((String)"name", (Object)name);
        GenericValue groupGenericValue = (GenericValue)Select.from("Group").whereEqual("directoryId", directoryId).andEqual("lowerGroupName", IdentifierUtils.toLowerCase((String)name)).runWith(this.ofBizDelegator).singleValue();
        if (groupGenericValue == null) {
            throw new GroupNotFoundException(name);
        }
        return groupGenericValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<OfBizGroup> findGroupsGenericValue(String name) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            Assertions.notNull((String)"name", (Object)name);
            List<OfBizGroup> list = Select.from("Group").whereEqual("lowerGroupName", IdentifierUtils.toLowerCase((String)name)).runWith(this.ofBizDelegator).asList(OfBizGroup::from);
            return list;
        }
        finally {
            this.groupDaoStats.findGroupsGenericValue(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    @Nullable
    private static String toLowerCaseAllowNull(String value) {
        return value != null ? IdentifierUtils.toLowerCase((String)value) : null;
    }

    private static Timestamp getCurrentTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }
}

