/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.database;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.DatabaseConfigurationService;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class DatabaseSchema {
    private static volatile Optional<String> schemaName = Optional.empty();

    public static void reset() {
        schemaName = Optional.empty();
    }

    public static String getSchemaName() {
        return schemaName.orElseGet(DatabaseSchema::init);
    }

    @Nonnull
    private static String init() {
        DatabaseConfigurationService svc = (DatabaseConfigurationService)ComponentAccessor.getComponent(DatabaseConfigurationService.class);
        String name = StringUtils.defaultString((String)svc.getSchemaName());
        schemaName = Optional.of(name);
        return name;
    }
}

