/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.database;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.database.DatabaseConnectionStateService;
import com.atlassian.jira.database.measure.DatabaseLatencyMeasuredEvent;
import com.atlassian.jira.database.measure.DatabaseLatencyMeter;
import com.google.common.base.Ticker;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.time.Duration;
import java.util.Optional;

public class DefaultDatabaseConnectionStateService
implements DatabaseConnectionStateService {
    private static final Duration DEFAULT_CACHE_EXPIRY = Duration.ofSeconds(5L);
    private static final Object LATENCY_CACHE_KEY = new Object();
    private final LoadingCache<Object, Optional<Duration>> cache;

    public DefaultDatabaseConnectionStateService(EventPublisher eventPublisher, DatabaseLatencyMeter databaseLatencyMeter) {
        this(eventPublisher, databaseLatencyMeter, Ticker.systemTicker());
    }

    DefaultDatabaseConnectionStateService(EventPublisher eventPublisher, final DatabaseLatencyMeter databaseLatencyMeter, Ticker ticker) {
        CacheLoader<Object, Optional<Duration>> cacheLoader = new CacheLoader<Object, Optional<Duration>>(){

            public Optional<Duration> load(Object key) {
                try {
                    return Optional.of(databaseLatencyMeter.measureWithoutEvent());
                }
                catch (RuntimeException ex) {
                    return Optional.empty();
                }
            }
        };
        this.cache = CacheBuilder.newBuilder().ticker(ticker).expireAfterWrite(DEFAULT_CACHE_EXPIRY).build((CacheLoader)cacheLoader);
        eventPublisher.register((Object)this);
    }

    @Override
    public Optional<Duration> getLatency() {
        return (Optional)this.cache.getUnchecked(LATENCY_CACHE_KEY);
    }

    @Override
    public DatabaseConnectionStateService.DatabaseConnectionState getState() {
        return this.getLatency().map(ignore -> DatabaseConnectionStateService.DatabaseConnectionState.CONNECTED).orElse(DatabaseConnectionStateService.DatabaseConnectionState.DISCONNECTED);
    }

    @EventListener
    public void onDatabaseLatencyMeasuredEvent(DatabaseLatencyMeasuredEvent event) {
        this.cache.put(LATENCY_CACHE_KEY, event.getLatency());
    }
}

