/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.database;

import com.atlassian.jira.database.OrderingMapper;
import com.atlassian.jira.model.querydsl.JiraRelationalPathBase;
import com.querydsl.core.QueryFlag;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.dml.Mapper;
import com.querydsl.sql.dml.SQLInsertClause;
import java.sql.Connection;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.DelegatorInterface;

public class IdGeneratingSQLInsertClause
extends SQLInsertClause {
    private final JiraRelationalPathBase<?> entity;
    private final DelegatorInterface delegatorInterface;

    public IdGeneratingSQLInsertClause(Connection con, SQLTemplates dialect, JiraRelationalPathBase<?> entity, DelegatorInterface delegatorInterface) {
        super(con, dialect, entity);
        this.entity = entity;
        this.delegatorInterface = delegatorInterface;
    }

    public IdGeneratingSQLInsertClause withId() {
        IdGeneratingSQLInsertClause.checkForNumericId(this.entity);
        Long id = this.delegatorInterface.getNextSeqId(this.entity.getEntityName());
        super.set(this.entity.getNumericIdPath(), (Object)id);
        return this;
    }

    @Nonnull
    public Long executeWithId() {
        IdGeneratingSQLInsertClause.checkForNumericId(this.entity);
        Long id = Objects.requireNonNull(this.delegatorInterface.getNextSeqId(this.entity.getEntityName()), "id");
        super.set(this.entity.getNumericIdPath(), (Object)id);
        super.execute();
        return id;
    }

    private static void checkForNumericId(JiraRelationalPathBase<?> entity) {
        if (!entity.hasNumericId()) {
            throw new UnsupportedOperationException("Entity '" + entity.getEntityName() + "' does not support automatic ID sequence generation.");
        }
    }

    public IdGeneratingSQLInsertClause columns(Path<?> ... columns) {
        super.columns(columns);
        return this;
    }

    public IdGeneratingSQLInsertClause select(SubQueryExpression<?> sq) {
        super.select(sq);
        return this;
    }

    public <T> IdGeneratingSQLInsertClause set(Path<T> path, T value) {
        super.set(path, value);
        return this;
    }

    public <T> IdGeneratingSQLInsertClause set(Path<T> path, Expression<? extends T> expression) {
        super.set(path, expression);
        return this;
    }

    public <T> IdGeneratingSQLInsertClause setNull(Path<T> path) {
        super.setNull(path);
        return this;
    }

    public IdGeneratingSQLInsertClause values(Object ... v) {
        super.values(v);
        return this;
    }

    public IdGeneratingSQLInsertClause populate(Object bean) {
        super.populate(bean, OrderingMapper.DEFAULT);
        return this;
    }

    public <T> IdGeneratingSQLInsertClause populate(T obj, Mapper<T> mapper) {
        super.populate(obj, mapper);
        return this;
    }

    public IdGeneratingSQLInsertClause addFlag(QueryFlag.Position position, Expression<?> flag) {
        super.addFlag(position, flag);
        return this;
    }

    public IdGeneratingSQLInsertClause addFlag(QueryFlag.Position position, String flag) {
        super.addFlag(position, flag);
        return this;
    }
}

