/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.database;

import com.atlassian.jira.database.ConnectionProvider;
import com.atlassian.jira.database.DatabaseVendor;
import com.atlassian.jira.database.DbConnection;
import com.atlassian.jira.database.QueryCallback;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.database.SqlCallback;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryDslAccessorHandlingCollationProblems
implements QueryDslAccessor {
    public static final String COLLATION_ERROR_LOG_MESSAGE = "We've detected your database contains mixed collation. Refer to this article on to how to resolve";
    static final String COLLATION_ERROR_MESSAGE_MYSQL = "Unknown error 1267";
    static final String COLLATION_ERROR_MESSAGE_MSSQL = "Cannot resolve the collation conflict between";
    private static final Map<DatabaseVendor, String> VENDOR_ERROR_MESSAGES = MapBuilder.newBuilder((Object)DatabaseVendor.MY_SQL, (Object)"Unknown error 1267").add((Object)DatabaseVendor.SQL_SERVER, (Object)"Cannot resolve the collation conflict between").toMap();
    private static final Logger log = LoggerFactory.getLogger(QueryDslAccessorHandlingCollationProblems.class);
    private final QueryDslAccessor delegate;
    private final String collationKBArticle;
    private final DatabaseVendor vendor;

    public QueryDslAccessorHandlingCollationProblems(QueryDslAccessor queryDslAccessor, DatabaseVendor vendor, String collationKBArticle) {
        Preconditions.checkNotNull((Object)collationKBArticle);
        Preconditions.checkNotNull((Object)vendor);
        Preconditions.checkArgument((!collationKBArticle.isEmpty() ? 1 : 0) != 0);
        this.delegate = queryDslAccessor;
        this.collationKBArticle = collationKBArticle;
        this.vendor = vendor;
    }

    private void handleCollationProblems(Throwable t) {
        if (this.isCollationRelatedError(t)) {
            log.error("{} : {}", new Object[]{COLLATION_ERROR_LOG_MESSAGE, this.collationKBArticle, t});
        }
    }

    private boolean isCollationRelatedError(Throwable throwable) {
        try {
            List allThrowables = Throwables.getCausalChain((Throwable)throwable);
            for (Throwable t : allThrowables) {
                if (!this.isKnownCollationErrorMessage(t.getMessage())) continue;
                return true;
            }
        }
        catch (IllegalArgumentException e) {
            log.debug("Loop in the causal chain", (Throwable)e);
        }
        return false;
    }

    private boolean isKnownCollationErrorMessage(String message) {
        return message != null && this.getCollationMessages().stream().anyMatch(m -> message.contains((CharSequence)m));
    }

    private Collection<String> getCollationMessages() {
        return VENDOR_ERROR_MESSAGES.containsKey(this.vendor) ? Arrays.asList(VENDOR_ERROR_MESSAGES.get(this.vendor)) : Collections.EMPTY_SET;
    }

    @Override
    public <T> T executeQuery(@Nonnull QueryCallback<T> callback) {
        try {
            return this.delegate.executeQuery(callback);
        }
        catch (Throwable t) {
            this.handleCollationProblems(t);
            throw t;
        }
    }

    @Override
    public void execute(@Nonnull SqlCallback callback) {
        try {
            this.delegate.execute(callback);
        }
        catch (Throwable t) {
            this.handleCollationProblems(t);
            throw t;
        }
    }

    @Override
    public ConnectionProvider withNewConnection() {
        return this.delegate.withNewConnection();
    }

    @Override
    public ConnectionProvider withLegacyOfBizTransaction() {
        return this.delegate.withLegacyOfBizTransaction();
    }

    @Override
    public DbConnection withDbConnection(Connection connection) {
        return this.delegate.withDbConnection(connection);
    }
}

