/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.issue;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.commit.OnCommitEvent;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.issue.IssueEventBundle;
import com.atlassian.jira.event.issue.IssueEventManager;
import com.atlassian.jira.event.issue.IssueEventParamsTransformer;
import com.atlassian.jira.event.issue.JiraIssueEvent;
import com.atlassian.jira.event.issue.commit.OnCommitIssueEvent;
import com.atlassian.jira.event.issue.commit.OnCommitIssueEventBuilder;
import com.atlassian.jira.event.issue.commit.OnCommitIssueEventBundle;
import com.atlassian.jira.event.issue.commit.OnCommitJiraIssueEventBuilder;
import com.atlassian.jira.event.issue.txnaware.TxnAwareEventFactory;
import com.atlassian.jira.event.operation.SpanningOperationHolder;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ImportUtils;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.GenericValue;

public class DefaultIssueEventManager
implements IssueEventManager {
    private final IssueEventParamsTransformer paramsTransformer;
    private final EventPublisher eventPublisher;
    private final TxnAwareEventFactory txnAwareEventFactory;
    private final SpanningOperationHolder spanningOperationHolder;

    public DefaultIssueEventManager(IssueEventParamsTransformer paramsTransformer, EventPublisher eventPublisher, TxnAwareEventFactory txnAwareEventFactory, SpanningOperationHolder spanningOperationHolder) {
        this.paramsTransformer = paramsTransformer;
        this.eventPublisher = (EventPublisher)Assertions.notNull((Object)eventPublisher);
        this.txnAwareEventFactory = txnAwareEventFactory;
        this.spanningOperationHolder = spanningOperationHolder;
    }

    public void dispatchEvent(Long eventTypeId, Issue issue, ApplicationUser remoteUser, boolean sendMail) {
        this.dispatchEvent(eventTypeId, issue, Collections.emptyMap(), remoteUser, sendMail);
    }

    public void dispatchEvent(Long eventTypeId, Issue issue, Map<String, Object> params, ApplicationUser remoteUser, boolean sendMail) {
        this.publishEvent(new IssueEvent(issue, remoteUser, null, null, null, this.transformParams(params), eventTypeId, sendMail, false, this.spanningOperationHolder.get()));
    }

    public void dispatchRedundantEvent(Long eventTypeId, Issue issue, Map<String, Object> params, ApplicationUser remoteUser, boolean sendMail) {
        this.publishAsRedundant(new IssueEvent(issue, remoteUser, null, null, null, this.transformParams(params), eventTypeId, sendMail, false, this.spanningOperationHolder.get()));
    }

    public void dispatchEvent(Long eventTypeId, Issue issue, Map params, ApplicationUser remoteUser) {
        this.publishEvent(new IssueEvent(issue, remoteUser, null, null, null, params, eventTypeId, true, false, this.spanningOperationHolder.get()));
    }

    public void dispatchEvent(Long eventTypeId, Issue issue, ApplicationUser remoteUser, Comment comment, Worklog worklog, GenericValue changelog) {
        this.publishEvent(new IssueEvent(issue, remoteUser, comment, worklog, changelog, this.transformParams(null), eventTypeId, true, false, this.spanningOperationHolder.get()));
    }

    public void dispatchRedundantEvent(Long eventTypeId, Issue issue, ApplicationUser remoteUser, Comment comment, Worklog worklog, GenericValue changelog) {
        this.publishAsRedundant(new IssueEvent(issue, remoteUser, comment, worklog, changelog, this.transformParams(null), eventTypeId, true, false, this.spanningOperationHolder.get()));
    }

    public void dispatchEvent(Long eventTypeId, Issue issue, ApplicationUser remoteUser, Comment comment, Worklog worklog, GenericValue changelog, boolean sendMail) {
        this.publishEvent(new IssueEvent(issue, remoteUser, comment, worklog, changelog, this.transformParams(null), eventTypeId, sendMail, false, this.spanningOperationHolder.get()));
    }

    public void dispatchEvent(Long eventTypeId, Issue issue, ApplicationUser remoteUser, Comment comment, Worklog worklog, GenericValue changelog, Map params) {
        this.publishEvent(new IssueEvent(issue, remoteUser, comment, worklog, changelog, this.transformParams(params), eventTypeId, true, false, this.spanningOperationHolder.get()));
    }

    public void dispatchRedundantEvent(Long eventTypeId, Issue issue, ApplicationUser remoteUser, Comment comment, Worklog worklog, GenericValue changelog, Map params) {
        this.publishAsRedundant(new IssueEvent(issue, remoteUser, comment, worklog, changelog, this.transformParams(params), eventTypeId, true, false, this.spanningOperationHolder.get()));
    }

    public void dispatchEvent(Long eventTypeId, Issue issue, ApplicationUser remoteUser, Comment comment, Worklog worklog, GenericValue changelog, Map params, boolean sendMail) {
        this.publishEvent(new IssueEvent(issue, remoteUser, comment, worklog, changelog, this.transformParams(params), eventTypeId, sendMail, false, this.spanningOperationHolder.get()));
    }

    public void dispatchRedundantEvent(Long eventTypeId, Issue issue, ApplicationUser remoteUser, Comment comment, Worklog worklog, GenericValue changelog, Map params, boolean sendMail) {
        this.publishAsRedundant(new IssueEvent(issue, remoteUser, comment, worklog, changelog, this.transformParams(params), eventTypeId, sendMail, false, this.spanningOperationHolder.get()));
    }

    public void dispatchEvent(Long eventTypeId, Issue issue, ApplicationUser remoteUser, GenericValue changelog, boolean sendMail, boolean subtasksUpdated) {
        this.publishEvent(new IssueEvent(issue, remoteUser, null, null, changelog, this.transformParams(null), eventTypeId, sendMail, subtasksUpdated, this.spanningOperationHolder.get()));
    }

    public void dispatchRedundantEvent(Long eventTypeId, Issue issue, ApplicationUser remoteUser, GenericValue changelog, boolean sendMail, boolean subtasksUpdated) {
        this.publishAsRedundant(new IssueEvent(issue, remoteUser, null, null, changelog, this.transformParams(null), eventTypeId, sendMail, subtasksUpdated, this.spanningOperationHolder.get()));
    }

    public void dispatchEvent(Long eventTypeId, Issue issue, ApplicationUser remoteUser, Comment comment, Worklog worklog, GenericValue changelog, Map params, boolean sendMail, boolean subtasksUpdated) {
        this.publishEvent(new IssueEvent(issue, remoteUser, comment, worklog, changelog, this.transformParams(params), eventTypeId, sendMail, subtasksUpdated, this.spanningOperationHolder.get()));
    }

    public void dispatchRedundantEvent(Long eventTypeId, Issue issue, ApplicationUser remoteUser, Comment comment, Worklog worklog, GenericValue changelog, Map params, boolean sendMail, boolean subtasksUpdated) {
        this.publishAsRedundant(new IssueEvent(issue, remoteUser, comment, worklog, changelog, this.transformParams(params), eventTypeId, sendMail, subtasksUpdated, this.spanningOperationHolder.get()));
    }

    public void dispatchIssueEventBundle(IssueEventBundle issueEventBundle, boolean shouldAlsoDispatchOnCommit) {
        for (JiraIssueEvent jiraIssueEvent : issueEventBundle.getEvents()) {
            this.publishEvent(jiraIssueEvent);
        }
        this.publishEvent(issueEventBundle);
        if (shouldAlsoDispatchOnCommit) {
            this.dispatchIssueEventBundleOnCommit(() -> () -> ((Collection)Option.option((Object)issueEventBundle.getEvents()).getOr(Collections::emptySet)).stream().map(jiraIssueEvent -> OnCommitJiraIssueEventBuilder.builder(jiraIssueEvent).setOnCommitEventDataReloadStatus(OnCommitEvent.OnCommitEventDataReloadStatus.NOT_RELOADED_ON_COMMIT).build()).collect(Collectors.toList()));
        }
    }

    public void dispatchIssueEventBundleOnCommit(Supplier<OnCommitIssueEventBundle> onCommitIssueEventBundleSupplier) {
        this.dispatchIssueEventBundleOnCommitIfNotificationsAreEnabled(onCommitIssueEventBundleSupplier);
    }

    public void dispatchIssueEventOnCommit(Supplier<OnCommitIssueEvent> onCommitIssueEventSupplier) {
        this.dispatchIssueEventOnCommitIfNotificationsAreEnabled(onCommitIssueEventSupplier);
    }

    private Map<String, Object> transformParams(Map<String, Object> params) {
        return this.paramsTransformer.transformParams(params);
    }

    private void publishEvent(IssueEvent event) {
        this.publishEventIfNotificationsAreEnabled(event);
        this.dispatchIssueEventOnCommitIfNotificationsAreEnabled(() -> OnCommitIssueEventBuilder.builder(event).setOnCommitEventDataReloadStatus(OnCommitEvent.OnCommitEventDataReloadStatus.NOT_RELOADED_ON_COMMIT).build());
    }

    private void publishEvent(JiraIssueEvent event) {
        this.publishEventIfNotificationsAreEnabled(event);
    }

    private void publishEvent(IssueEventBundle eventBundle) {
        this.publishEventIfNotificationsAreEnabled(eventBundle);
    }

    private void publishEventIfNotificationsAreEnabled(Object event) {
        if (this.areNotificationsEnabled()) {
            this.eventPublisher.publish(event);
        }
    }

    private void dispatchIssueEventOnCommitIfNotificationsAreEnabled(Supplier<OnCommitIssueEvent> onCommitIssueEventSupplier) {
        if (this.areNotificationsEnabled()) {
            this.txnAwareEventFactory.publishOnCommitEvent(onCommitIssueEventSupplier::get);
        }
    }

    private void dispatchIssueEventBundleOnCommitIfNotificationsAreEnabled(Supplier<OnCommitIssueEventBundle> onCommitIssueEventBundleSupplier) {
        if (this.areNotificationsEnabled()) {
            this.txnAwareEventFactory.publishOnCommitIssueEventBundle(onCommitIssueEventBundleSupplier);
        }
    }

    @VisibleForTesting
    boolean areNotificationsEnabled() {
        return ImportUtils.isEnableNotifications();
    }

    @VisibleForTesting
    void publishAsRedundant(@Nonnull IssueEvent issueEvent) {
        issueEvent.makeRedundant();
        this.publishEvent(issueEvent);
    }
}

