/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.issue;

import com.atlassian.jira.event.issue.ChangeItemBeanKit;
import com.atlassian.jira.event.issue.IssueChangedEvent;
import com.atlassian.jira.event.operation.SpanningOperation;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.MoreObjects;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IssueChangedEventImpl
implements IssueChangedEvent {
    private final Collection<ChangeItemBean> changeItems;
    private final Optional<ApplicationUser> author;
    private final Optional<Comment> comment;
    private final Issue issue;
    private final Date eventTime;
    private final boolean sendMail;
    private final SpanningOperation spanningOperation;

    public IssueChangedEventImpl(@Nonnull Issue issue, @Nonnull Optional<ApplicationUser> author, @Nonnull Collection<ChangeItemBean> changeItems, @Nonnull Optional<Comment> comment, @Nonnull Date eventTime, boolean sendMail, @Nullable SpanningOperation spanningOperation) {
        this.changeItems = changeItems;
        this.author = author;
        this.comment = comment;
        this.issue = issue;
        this.eventTime = eventTime;
        this.sendMail = sendMail;
        this.spanningOperation = spanningOperation;
    }

    @Nonnull
    public Collection<ChangeItemBean> getChangeItems() {
        return this.changeItems;
    }

    @Nonnull
    public Optional<ChangeItemBean> getChangeItemForField(@Nonnull String fieldName) {
        return ChangeItemBeanKit.getFieldChange(fieldName, this.changeItems);
    }

    public boolean isSendMail() {
        return this.sendMail;
    }

    @Nonnull
    public Optional<ApplicationUser> getAuthor() {
        return this.author;
    }

    @Nonnull
    public Optional<Comment> getComment() {
        return this.comment;
    }

    public Issue getIssue() {
        return this.issue;
    }

    public Date getTime() {
        return this.eventTime;
    }

    public Map<String, Object> getParams() {
        return Collections.emptyMap();
    }

    public Optional<SpanningOperation> getSpanningOperation() {
        return Optional.ofNullable(this.spanningOperation);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("changeItems", this.changeItems).add("author", this.author).add("comment", this.comment).add("issue", (Object)this.issue).add("eventTime", (Object)this.eventTime).add("sendMail", this.sendMail).add("spanningOperation", (Object)this.spanningOperation).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueChangedEventImpl that = (IssueChangedEventImpl)o;
        return this.sendMail == that.sendMail && Objects.equals(this.changeItems, that.changeItems) && Objects.equals(this.author, that.author) && Objects.equals(this.comment, that.comment) && Objects.equals(this.issue, that.issue) && Objects.equals(this.eventTime, that.eventTime) && Objects.equals(this.spanningOperation, that.spanningOperation);
    }

    public int hashCode() {
        return Objects.hash(this.changeItems, this.author, this.comment, this.issue, this.eventTime, this.sendMail, this.spanningOperation);
    }
}

