/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.favourites;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.favourites.FavouritesStore;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.anonymize.handlers.key.info.events.FavouriteAssociationsFKChangedEvent;
import com.atlassian.jira.util.dbc.Assertions;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class CachingFavouritesStore
implements FavouritesStore,
Startable {
    private static final Logger log = LoggerFactory.getLogger(CachingFavouritesStore.class);
    private final Cache<Key, Collection<Long>> favouritesCache;
    private final FavouritesStore delegateStore;

    public CachingFavouritesStore(FavouritesStore delegateStore, CacheManager cacheManager) {
        this.delegateStore = (FavouritesStore)Assertions.notNull((String)"delegateStore", (Object)delegateStore);
        this.favouritesCache = cacheManager.getCache(this.getClass().getName() + ".favouritesCache", this::loadKeyCollection, new CacheSettingsBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).maxEntries(1000).build());
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.clearCache();
    }

    @EventListener
    public void onFavouriteAssociationsFKChangedEvent(FavouriteAssociationsFKChangedEvent event) {
        this.clearCache();
    }

    private void clearCache() {
        log.debug("clearing caches");
        this.favouritesCache.removeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addFavourite(ApplicationUser user, SharedEntity entity) {
        try {
            boolean bl = this.delegateStore.addFavourite((ApplicationUser)Assertions.notNull((String)"user", (Object)user), (SharedEntity)Assertions.notNull((String)"entity", (Object)entity));
            return bl;
        }
        finally {
            this.flushFavourites(user, entity.getEntityType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeFavourite(ApplicationUser user, SharedEntity entity) {
        try {
            boolean bl = this.delegateStore.removeFavourite((ApplicationUser)Assertions.notNull((String)"user", (Object)user), (SharedEntity)Assertions.notNull((String)"entity", (Object)entity));
            return bl;
        }
        finally {
            this.flushFavourites(user, entity.getEntityType());
        }
    }

    @Override
    public boolean isFavourite(ApplicationUser user, SharedEntity entity) {
        Collection<Long> ids = this.getFavouriteIds((ApplicationUser)Assertions.notNull((String)"user", (Object)user), ((SharedEntity)Assertions.notNull((String)"entity", (Object)entity)).getEntityType());
        return ids.contains(entity.getId());
    }

    @Override
    public Collection<Long> getFavouriteIds(ApplicationUser user, SharedEntity.TypeDescriptor<?> entityType) {
        return this.getFavouriteIds(((ApplicationUser)Assertions.notNull((String)"user", (Object)user)).getKey(), (SharedEntity.TypeDescriptor)Assertions.notNull((String)"entityType", entityType));
    }

    @Override
    public Collection<Long> getFavouriteIds(String userKey, SharedEntity.TypeDescriptor<?> entityType) {
        Key key = new Key((String)Assertions.notNull((String)"user", (Object)userKey), (SharedEntity.TypeDescriptor)Assertions.notNull((String)"entityType", entityType));
        return (Collection)this.favouritesCache.get((Object)key);
    }

    @Override
    public void removeFavouritesForUser(ApplicationUser user, SharedEntity.TypeDescriptor<?> entityType) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"entityType", entityType);
        try {
            this.delegateStore.removeFavouritesForUser(user, entityType);
        }
        finally {
            this.flushFavourites(user, entityType);
        }
    }

    @Override
    public void removeFavouritesForEntity(SharedEntity entity) {
        try {
            this.delegateStore.removeFavouritesForEntity(entity);
        }
        finally {
            this.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSequence(ApplicationUser user, List<? extends SharedEntity> favouriteEntities) {
        try {
            this.delegateStore.updateSequence(user, favouriteEntities);
        }
        finally {
            if (!favouriteEntities.isEmpty()) {
                SharedEntity entity = favouriteEntities.get(0);
                this.flushFavourites(user, entity.getEntityType());
            }
        }
    }

    private void flushFavourites(ApplicationUser user, SharedEntity.TypeDescriptor<?> typeDescriptor) {
        if (user != null) {
            this.favouritesCache.remove((Object)new Key(user.getKey(), typeDescriptor));
        }
    }

    public void start() throws Exception {
    }

    @Nonnull
    private Collection<Long> loadKeyCollection(Key key) {
        Collection<Long> ids = this.delegateStore.getFavouriteIds(key.getUserKey(), key.getType());
        if (ids == null) {
            ids = Collections.emptyList();
        }
        return ids;
    }

    private static class Key
    implements Serializable {
        private final String userKey;
        private final SharedEntity.TypeDescriptor<?> type;

        public Key(String userKey, SharedEntity.TypeDescriptor<?> type) {
            Assertions.notNull((String)"user", (Object)userKey);
            Assertions.notNull((String)"type", type);
            this.userKey = userKey;
            this.type = type;
        }

        public String getUserKey() {
            return this.userKey;
        }

        public SharedEntity.TypeDescriptor<?> getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (!this.type.equals(key.type)) {
                return false;
            }
            return this.userKey.equals(key.userKey);
        }

        public int hashCode() {
            int result = this.userKey.hashCode();
            result = 31 * result + this.type.hashCode();
            return result;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SIMPLE_STYLE);
        }
    }
}

