/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health;

import com.atlassian.jira.health.HealthCheck;
import com.atlassian.jira.health.HealthCheckExecutor;
import com.atlassian.jira.health.HealthCheckResult;
import com.atlassian.jira.health.LifecyclePhase;
import com.atlassian.jira.util.johnson.JohnsonEventPredicates;
import com.atlassian.johnson.event.Event;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Pair;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class DefaultHealthCheckExecutor
implements HealthCheckExecutor {
    private static final Logger log = LoggerFactory.getLogger(DefaultHealthCheckExecutor.class);
    private final Collection<HealthCheck> blockingChecks = new HashSet<HealthCheck>();

    @Override
    public Set<HealthCheckResult> performHealthChecks(Collection<HealthCheck> healthChecks, LifecyclePhase lifecyclePhase) {
        return (Set)this.applyAndCollectExceptions(healthChecks, lifecyclePhase).right();
    }

    @VisibleForTesting
    protected Pair<Collection<Exception>, Set<HealthCheckResult>> applyAndCollectExceptions(Collection<HealthCheck> healthChecks, LifecyclePhase lifecyclePhase) {
        this.blockingChecks.clear();
        LinkedHashSet results = new LinkedHashSet();
        HashSet healthChecksRun = new HashSet();
        ArrayList exceptions = new ArrayList();
        healthChecks.stream().filter(check -> check.isApplicableFor(lifecyclePhase)).forEach(check -> this.runCheck((HealthCheck)check, lifecyclePhase, results, healthChecksRun, exceptions));
        return Pair.pair(exceptions, results);
    }

    private boolean hasFailedPrerequisites(HealthCheck healthCheck) {
        return healthCheck.getPrerequisites().stream().anyMatch(this.blockingChecks::contains);
    }

    private void runCheck(HealthCheck healthCheck, LifecyclePhase lifecyclePhase, Set<HealthCheckResult> results, Set<HealthCheck> healthChecksRun, Collection<Exception> exceptions) {
        if (this.hasFailedPrerequisites(healthCheck)) {
            healthChecksRun.add(healthCheck);
            this.blockingChecks.add(healthCheck);
        } else {
            try {
                this.checkPrerequisitesAllRanInThisPhase(healthCheck, healthChecksRun, lifecyclePhase);
                healthCheck.perform(lifecyclePhase).forEach(result -> this.recordResult((HealthCheckResult)result, results));
                healthChecksRun.add(healthCheck);
            }
            catch (RuntimeException e) {
                log.error("Failure running HealthCheck " + healthCheck.getId(), (Throwable)e);
                exceptions.add(e);
            }
        }
    }

    private void checkPrerequisitesAllRanInThisPhase(HealthCheck healthCheck, Set<HealthCheck> healthChecksRun, LifecyclePhase lifecyclePhase) {
        Set missingPrerequisites = healthCheck.getPrerequisites().stream().filter(c -> !healthChecksRun.contains(c)).collect(Collectors.toSet());
        if (!missingPrerequisites.isEmpty()) {
            throw new PrerequisiteNotInPhaseException("One or more prerequisites for the HealthCheck '" + healthCheck.getId() + "' were not run in phase " + lifecyclePhase.toString() + ". Missing prerequisites: " + StringUtils.join((Iterable)missingPrerequisites.stream().map(HealthCheck::getId).collect(Collectors.toSet()), (String)", "), healthCheck);
        }
    }

    private void recordResult(HealthCheckResult result, Set<HealthCheckResult> results) {
        Event johnsonEvent = result.getEvent();
        DefaultHealthCheckExecutor.addEventAttributes(johnsonEvent, result.getCause(), result.getHealthCheck().getId(), result.getKbUrl());
        results.add(result);
        if (DefaultHealthCheckExecutor.isBlocking(johnsonEvent)) {
            this.blockingChecks.add(result.getHealthCheck());
        }
    }

    public static void addEventAttributes(Event johnsonEvent, String cause, String id, Optional<URL> optionalKbUrl) {
        johnsonEvent.addAttribute((Object)"causeKey", (Object)cause);
        johnsonEvent.addAttribute((Object)"idKey", (Object)id);
        johnsonEvent.addAttribute((Object)"eventKey", (Object)UUID.randomUUID().toString());
        optionalKbUrl.ifPresent(url -> johnsonEvent.addAttribute((Object)"helpUrl", url));
        DefaultHealthCheckExecutor.markForRenderingInBetterJohnsonPage(johnsonEvent);
    }

    private static boolean isBlocking(Event event) {
        return JohnsonEventPredicates.blocksStartup().test(event);
    }

    private static void markForRenderingInBetterJohnsonPage(Event event) {
        event.addAttribute((Object)"uiVersion", (Object)"CPU-59");
    }

    @VisibleForTesting
    protected static class PrerequisiteNotInPhaseException
    extends RuntimeException {
        private final HealthCheck healthCheck;

        protected PrerequisiteNotInPhaseException(String message, HealthCheck healthCheck) {
            super(message);
            this.healthCheck = healthCheck;
        }

        public HealthCheck getHealthCheck() {
            return this.healthCheck;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PrerequisiteNotInPhaseException that = (PrerequisiteNotInPhaseException)o;
            return this.healthCheck.equals(that.healthCheck) && this.getMessage().equals(that.getMessage());
        }

        public int hashCode() {
            return this.healthCheck.hashCode() * 42 + this.getMessage().hashCode();
        }
    }
}

