/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.text.StringEscapeUtils;

@ParametersAreNonnullByDefault
public class HealthCheckMessageFormatter {
    private static final String LINK_ELEMENT_FORMAT = "<a href=\"%s\"%s>%s</a>";
    private final StringBuilder html = new StringBuilder();
    private final StringBuilder text = new StringBuilder();

    private static String openingTag(String tag) {
        return "<" + tag + ">";
    }

    private static String closingTag(String tag) {
        return "</" + tag + ">";
    }

    @Nonnull
    public static HealthCheckMessageFormatter string(String s) {
        HealthCheckMessageFormatter formatter = new HealthCheckMessageFormatter();
        formatter.html.append(StringEscapeUtils.escapeHtml4((String)s));
        formatter.text.append(s);
        return formatter;
    }

    @Nonnull
    public static HealthCheckMessageFormatter tag(String tag, HealthCheckMessageFormatter content) {
        HealthCheckMessageFormatter formatter = new HealthCheckMessageFormatter();
        formatter.appendTag(HealthCheckMessageFormatter.openingTag(tag)).append(content).appendTag(HealthCheckMessageFormatter.closingTag(tag));
        return formatter;
    }

    private HealthCheckMessageFormatter appendTag(String tag) {
        this.html.append(tag);
        return this;
    }

    @Nonnull
    public HealthCheckMessageFormatter appendList(HealthCheckMessageFormatter ... items) {
        return this.appendList(Arrays.asList(items));
    }

    @Nonnull
    public HealthCheckMessageFormatter appendList(Iterable<HealthCheckMessageFormatter> items) {
        this.appendTag(HealthCheckMessageFormatter.openingTag("ul"));
        for (HealthCheckMessageFormatter item : items) {
            this.html.append(HealthCheckMessageFormatter.tag("li", item).toHtml());
            this.text.append("\t- ").append(item.toText()).append(System.lineSeparator());
        }
        return this.appendTag(HealthCheckMessageFormatter.closingTag("ul"));
    }

    @Nonnull
    public HealthCheckMessageFormatter appendLink(String url, String linkText, boolean newTab) {
        this.html.append(HealthCheckMessageFormatter.getLinkAsHtml(url, newTab, linkText));
        String logMessage = linkText + " (" + url + ")";
        this.text.append(logMessage);
        return this;
    }

    @VisibleForTesting
    static String getLinkAsHtml(String url, boolean newTab, String linkText) {
        String targetAttribute = newTab ? " target=\"_blank\"" : "";
        return String.format(LINK_ELEMENT_FORMAT, url, targetAttribute, linkText);
    }

    @Nonnull
    public HealthCheckMessageFormatter addLineBreak() {
        this.html.append("<br/>");
        this.text.append(System.lineSeparator());
        return this;
    }

    @Nonnull
    public HealthCheckMessageFormatter append(HealthCheckMessageFormatter ... formatters) {
        for (HealthCheckMessageFormatter formatter : formatters) {
            this.html.append(formatter.toHtml());
            this.text.append(formatter.toText());
        }
        return this;
    }

    @Nonnull
    public String toHtml() {
        return this.html.toString();
    }

    @Nonnull
    public String toText() {
        return this.text.toString();
    }
}

