/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health;

import com.atlassian.jira.health.ConfigurationHashService;
import com.atlassian.jira.health.PreviousVersionHashService;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ModificationsMigrationService {
    private final PreviousVersionHashService previousVersionHashService;
    private final ConfigurationHashService configurationHashService;

    public ModificationsMigrationService(PreviousVersionHashService previousVersionHashService, ConfigurationHashService configurationHashService) {
        this.previousVersionHashService = Objects.requireNonNull(previousVersionHashService);
        this.configurationHashService = Objects.requireNonNull(configurationHashService);
    }

    public static ModificationsMigrationService getInstance() {
        return new ModificationsMigrationService(PreviousVersionHashService.getInstance(), ConfigurationHashService.getInstance());
    }

    @Nonnull
    public Set<Path> checkCopyingNotPossible(Set<Path> candidatePaths) {
        return this.previousVersionHashService.withHashProvider(baselineHashProvider -> candidatePaths.stream().filter(file -> !this.isBaselineHashAreTheSame((Path)file, (PreviousVersionHashService.HashProvider)baselineHashProvider)).collect(Collectors.toSet()));
    }

    private boolean isBaselineHashAreTheSame(Path file, PreviousVersionHashService.HashProvider baselineHashProvider) {
        Optional<String> versionUpgradeFrom = baselineHashProvider.getHash(file);
        Optional<String> versionUpgradeTo = this.configurationHashService.calculateHash(file);
        if (!versionUpgradeFrom.isPresent() || !versionUpgradeTo.isPresent()) {
            return false;
        }
        return versionUpgradeFrom.get().equals(versionUpgradeTo.get());
    }
}

